package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.business.prjfinance.mapper.PrjOtherCostMapper;
import com.ejianc.business.prjfinance.service.IPrjOtherCostService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 其它费用
 * 
 * @author generator
 * 
 */
@Service("otherCostService")
public class PrjOtherCostServiceImpl extends BaseServiceImpl<PrjOtherCostMapper, PrjOtherCostEntity> implements IPrjOtherCostService {

    @Autowired
    private PrjOtherCostMapper costMapper;

    /**
     * 合计当前项目下的扣除累计金额和新增退还
     * @param projectId
     * @param billType
     * @return
     */
    public Map<String, BigDecimal> queryCumAmount(Long projectId, String billType) {

        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<PrjOtherCostEntity> query = new QueryWrapper<>();
        query.select("  sum(apply_mn) as totalAmount  ");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("bill_types", billType);
        query.in("bill_state",BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalAmount", null != data.get("totalAmount") ? new BigDecimal(data.get("totalAmount").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalAmount", BigDecimal.ZERO);
        }
        return resp;

    }

    /**
     * 查询全部金额累计
     * @param param
     * @return
     */
    @Override
    public Map<String, BigDecimal> queryCumAmountListAll(QueryParam param) {

        Map<String, BigDecimal> resp = new HashMap<>();
        Map<String, Object> queryResult = null;
        QueryWrapper<PrjOtherCostEntity> query = changeToQueryWrapper(param);

        query.select(" sum( CASE WHEN bill_types = 0 THEN apply_mn ELSE 0 END ) AS deductionAmount ,sum( CASE WHEN bill_types = 1 THEN apply_mn ELSE 0 END ) AS refundAmount ");
        //query.in("bill_state",BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());

        queryResult = super.getMap(query);

        if(null != queryResult) {
            resp.put("deductionAmount", null != queryResult.get("deductionAmount") ? new BigDecimal(queryResult.get("deductionAmount").toString()) :  BigDecimal.ZERO.setScale(8));
            resp.put("refundAmount", null != queryResult.get("refundAmount") ? new BigDecimal(queryResult.get("refundAmount").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("deductionAmount", BigDecimal.ZERO);
            resp.put("refundAmount", BigDecimal.ZERO);
        }
        return resp;
    }

    /**
     * 提供项目责任书查询 累计扣除/累计返还/累计结余
     * @param projectId
     * @return
     */
    public Map<String, BigDecimal> queryProjectCumAllAmount(Long projectId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<PrjOtherCostEntity> query = new QueryWrapper<>();

        query.select(" sum( CASE WHEN bill_types = 1 THEN apply_mn ELSE 0 END ) AS refundAmount ,sum( CASE WHEN bill_types = 0 THEN apply_mn ELSE 0 END ) AS deductionAmount ");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state",BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());

        Map<String, Object> data = super.getMap(query);

        if(null != data) {
            resp.put("deductionAmount", null != data.get("deductionAmount") ? new BigDecimal(data.get("deductionAmount").toString()) :  BigDecimal.ZERO.setScale(8));
            resp.put("refundAmount", null != data.get("refundAmount") ? new BigDecimal(data.get("refundAmount").toString()) :  BigDecimal.ZERO.setScale(8));
            resp.put("cumDeductionMn", resp.get("deductionAmount").subtract(resp.get("refundAmount")));
        } else {
            resp.put("deductionAmount", BigDecimal.ZERO);
            resp.put("refundAmount", BigDecimal.ZERO);
            resp.put("cumDeductionMn", BigDecimal.ZERO);
        }

        return resp;
    }

    /**
     * 查询列表（提供给项目责任书）
     * @param projectId
     * @return
     */
    public List<PrjOtherCostEntity> queryProjectList(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("dr",new Parameter(QueryParam.IN,"0"));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        param.getOrderMap().put("handleDate",QueryParam.DESC);
        List<PrjOtherCostEntity> list = this.queryList(param);
        return list;
    }

}
