/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.service.IReturnMoneySubService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="returnMoney")
public class ReturnMoneyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IReturnMoneyService iReturnMoneyService;
    @Autowired
    private IReturnMoneySubService returnMoneySubService;
    @Autowired
    private IProjectLoanService iProjectLoanService;
    @Autowired
    private IProjectLoanService projectLoanService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnMoneyEntity main = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<ReturnMoneySubEntity> subEntities = main.getReturnMoneySubEntities();
        if (ListUtil.isNotEmpty(subEntities)) {
            for (ReturnMoneySubEntity subEntity : subEntities) {
                this.iProjectLoanService.updateBillAllReturnMoney(subEntity.getLoanId(), subEntity.getReturnMny(), 1);
                if (!subEntity.getLoanMoney().equals(subEntity.getReturnMny())) continue;
                ProjectLoanEntity projectLoanEntity = (ProjectLoanEntity)((Object)this.projectLoanService.selectById(subEntity.getLoanId()));
                projectLoanEntity.setLoanMoneyYornState(1);
                this.projectLoanService.saveOrUpdate((Object)projectLoanEntity);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnMoneyEntity main = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)main.getProjectId()));
        param.getOrderMap().put("dealDate", "desc");
        List list = this.iReturnMoneyService.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && !billId.equals(((ReturnMoneyEntity)((Object)list.get(0))).getId())) {
            CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6700\u65b0\u5df2\u5ba1\u6838\u5355\u636e\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5"));
        list = this.iReturnMoneyService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            CommonResponse.error((String)"\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnMoneyEntity main = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<ReturnMoneySubEntity> subEntities = main.getReturnMoneySubEntities();
        if (ListUtil.isNotEmpty(subEntities)) {
            for (ReturnMoneySubEntity subEntity : subEntities) {
                this.iProjectLoanService.updateBillAllReturnMoney(subEntity.getLoanId(), subEntity.getReturnMny(), 2);
                ProjectLoanEntity projectLoanEntity = (ProjectLoanEntity)((Object)this.projectLoanService.selectById(subEntity.getLoanId()));
                projectLoanEntity.setLoanMoneyYornState(0);
                this.projectLoanService.saveOrUpdate((Object)projectLoanEntity);
            }
        }
        return CommonResponse.success();
    }
}

