package com.ejianc.business.prjfinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author liyongjia
 * @Description:
 * @date 2021/7/29 14:01
 */
@RestController
@RequestMapping("/api/projectDutyLetter/")
public class ProjectDutyLetterApi {

    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;

    @Autowired
    private IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;


	/**
	 * 根据项目Id查询对应的联营项目费用列表
	 */
	@PostMapping(value = "getOperationList")
	public CommonResponse<List<OperationCostVO>> getOperationList(@RequestBody OperationCostVO operationCostVO) {
		List<OperationCostVO> operationCostVOList = projectDutyLetterService.getOperationList(operationCostVO);
		return CommonResponse.success("查询联营项目费用列表！", operationCostVOList);
	}

    /**
     * 根据项目Id查询对应的
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "getCostMoneyByProjectId")
    public CommonResponse<BigDecimal> getCostMoneyByProjectId(@RequestParam Long projectId) {
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(projectId);
		Long tenantid = InvocationInfoProxy.getTenantid();
		List<ProjectDutyLetterCostlistEntity> costList = projectDutyLetterCostlistService.getCostListByProjectIds(projectIds,tenantid);
        //累计扣除
        BigDecimal allDelete = new BigDecimal(0);
        //累计返还
        BigDecimal allAdd = new BigDecimal(0);
        //累计结余
        BigDecimal amount = new BigDecimal(0);
		CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(projectId);
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(costList!=null&&costList.size()>0){
				for(ProjectDutyLetterCostlistEntity cost : costList) {
					if (null == cost.getTaxCostId()) {
						if (cost.getFormula() != null) {
							String evalq = cost.getFormula();
							for (String key : dataresultIncoemAndExpend.keySet()) {
								String value = "0";
								value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
								evalq = evalq.replaceAll(key, value);
							}

							ScriptEngineManager manager = new ScriptEngineManager();
							ScriptEngine se = manager.getEngineByName("js");
							BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
							} catch (Exception e) {
								e.printStackTrace();
							}
							cost.setAmount(money);
						} else {
							cost.setAmount(new BigDecimal(0));
						}
					}
					if ("del".equals(cost.getBackOrDel())) {
						allDelete= ComputeUtil.safeAdd(allDelete,cost.getAmount());
					} else {
						allAdd=ComputeUtil.safeAdd(allAdd,cost.getAmount());
					}
				}
        		//将费用详情金额（冗余-供报表查询）数据进行保存
        		projectDutyLetterCostlistService.saveOrUpdateBatch(costList, costList.size(), false);
        	}
        }
        amount = allDelete.subtract(allAdd);
		return CommonResponse.success(amount);
    }

}
