package com.ejianc.business.prjfinance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目代转款
 *
 * @author CJ
 * @Description:
 * @date 2021/7/21 19:23
 */
@TableName(value = "ejc_prjfinance_prj_advance_pay")
public class PrjAdvancePaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 3457416980544742476L;

    /**
     * 所属项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 单据编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 单据类型：1-收款登记，2-退款申请
     */
    @TableField(value = "bill_type")
    private String billType;

    /**
     * 所属项目Id
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 主题
     */
    @TableField(value = "subject")
    private String subject;

    /**
     * 金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 办理日期
     */
    @TableField(value = "handling_date")
    private Date handlingDate;

    /**
     * 收/付款方式
     */
    @TableField(value = "transaction_mode")
    private Long transactionMode;

    /**
     * 收/付款方式
     */
    @TableField(value = "transaction_mode_name")
    private String transactionModeName;

    /**
     * 经办人名称
     */
    @TableField(value = "operator_name")
    private String operatorName;

    /**
     * 经办人Id
     */
    @TableField(value = "operator_id")
    private Long operatorId;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 所属组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;


    /**
     * 商机登记Id
     */
    @TableField(value = "oppor_id")
    private Long opporId;

    /**
     * 商机登记名称
     */
    @TableField(value = "oppor_name")
    private String opporName;
    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    //    退款申请使用字段
    /**
     * 收款账号账户名
     */
    @TableField(value = "rec_bank_acc_name")
    private String recBankAccName;
    /**
     * 收款账号银行账号
     */
    @TableField(value = "rec_bank_acc")
    private String recBankAcc;
    /**
     * 收款账号开户行
     */
    @TableField(value = "rec_open_acc_bank_name")
    private String recOpenAccBankName;

    public Long getTransactionMode() {
        return transactionMode;
    }

    public void setTransactionMode(Long transactionMode) {
        this.transactionMode = transactionMode;
    }

    public String getTransactionModeName() {
        return transactionModeName;
    }

    public void setTransactionModeName(String transactionModeName) {
        this.transactionModeName = transactionModeName;
    }

    public String getRecBankAccName() {
        return recBankAccName;
    }

    public void setRecBankAccName(String recBankAccName) {
        this.recBankAccName = recBankAccName;
    }

    public String getRecBankAcc() {
        return recBankAcc;
    }

    public void setRecBankAcc(String recBankAcc) {
        this.recBankAcc = recBankAcc;
    }

    public String getRecOpenAccBankName() {
        return recOpenAccBankName;
    }

    public void setRecOpenAccBankName(String recOpenAccBankName) {
        this.recOpenAccBankName = recOpenAccBankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Date getHandlingDate() {
        return handlingDate;
    }

    public void setHandlingDate(Date handlingDate) {
        this.handlingDate = handlingDate;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getRemark() {
        return remark;
    }

    public Long getOpporId() {
        return opporId;
    }

    public void setOpporId(Long opporId) {
        this.opporId = opporId;
    }

    public String getOpporName() {
        return opporName;
    }

    public void setOpporName(String opporName) {
        this.opporName = opporName;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
