package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterExportVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author liyongjia
 * @Date 2021/5/11
 * @Description ProjectCapitalSetController
 */

@Controller
@RequestMapping("/projectDutyLetter/")
public class ProjectDutyLetterController {    
	private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterController.class);
    private static final String projectDutyLetter_BILL_CODE = "projectDutyLetter";

    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;
	@Autowired
	private IInvoiceApi invoiceApi;
    
    /**
     * @Author liyongjia
     * @Date 2021/5/11  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return 
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> saveOrUpdate(@RequestBody ProjectDutyLetterVO vo) {
    	//检验项目是否唯一，若存在则不能新增
    	checkProject(vo);
        ProjectDutyLetterEntity entity = BeanMapper.map(vo, ProjectDutyLetterEntity.class);
		if(entity.getId()==null){
			//新增，没有单据编码要设置单据编码（判重）
			if(StringUtils.isBlank(vo.getBillCode())){
				CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(projectDutyLetter_BILL_CODE,InvocationInfoProxy.getTenantid());
	            if(billCode.isSuccess()) {
	                entity.setBillCode(billCode.getData());
	            }else{
	                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
	            }
			}
			entity.setChangeState("0");
		}
        projectDutyLetterService.saveOrUpdate(entity,false);
        ProjectDutyLetterVO backVo = BeanMapper.map(entity, ProjectDutyLetterVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }
    
    public void checkProject(ProjectDutyLetterVO vo) {
		QueryParam queryParam = new QueryParam();
		if(StringUtils.isNotBlank(vo.getBillCode())){
			ComplexParam c1 = new ComplexParam();
	        c1.setLogic(ComplexParam.AND);

	        ComplexParam c2 = new ComplexParam();
	        c2.setLogic(ComplexParam.OR);
	        c2.getParams().put("projectId", new Parameter(QueryParam.EQ, vo.getProjectId()));

	        ComplexParam c3 = new ComplexParam();
	        c3.setLogic(ComplexParam.OR);
	        c3.getParams().put("billCode", new Parameter(QueryParam.EQ, vo.getBillCode()));

	        c1.getComplexParams().add(c2);
	        c1.getComplexParams().add(c3);
	        queryParam.getComplexParams().add(c1);
		}else{
			queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ,vo.getProjectId()));
		}
        
		if(vo.getId()!=null){
			queryParam.getParams().put("id", new Parameter(QueryParam.NE,vo.getId()));
		}
		queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		List<ProjectDutyLetterEntity> list = projectDutyLetterService.queryList(queryParam, false);
		if(list!=null&&list.size()>0){
			//已存在，不允许修改
			if(StringUtils.isNotBlank(vo.getBillCode())){
				if(list.get(0).getBillCode().equals(vo.getBillCode())){
					throw new BusinessException("编码已存在，请重新填写");
				}
				if(list.get(0).getProjectId().equals(vo.getProjectId())){
					throw new BusinessException("项目已存在，请重新选择项目");
				}
			}else{
				throw new BusinessException("项目已存在，请重新选择项目");
			}
		}
    }
    
    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterEntity entity = projectDutyLetterService.selectById(id);
        ProjectDutyLetterVO vo = BeanMapper.map(entity, ProjectDutyLetterVO.class);
        CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectDutyLetterCostList()!=null&&vo.getProjectDutyLetterCostList().size()>0){
        		List<ProjectDutyLetterCostlistVO> list = vo.getProjectDutyLetterCostList();
        		for(ProjectDutyLetterCostlistVO cost : list){
        			if (null==cost.getTaxCostId()) {
						if (cost.getFormula() != null) {
							String evalq = cost.getFormula();
							for (String key : dataresultIncoemAndExpend.keySet()) {
								String value = "0";
								value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
								evalq = evalq.replaceAll(key, value);
							}

							ScriptEngineManager manager = new ScriptEngineManager();
							ScriptEngine se = manager.getEngineByName("js");
							BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
							} catch (Exception e) {
								e.printStackTrace();
							}
//    					if("del".equals(cost.getAddOrDelete())){
//    						money = new BigDecimal(0).subtract(money);
//    					}
							cost.setAmount(ComputeUtil.scaleTwo(money));
						} else {
							cost.setAmount(new BigDecimal(0));
						}
					}
        		}
        		//将费用详情金额（冗余-供报表查询）数据进行保存
        		projectDutyLetterCostlistService.saveOrUpdateBatch(BeanMapper.mapList(list, ProjectDutyLetterCostlistEntity.class), list.size(), false);
        	}
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryList
     * @Param [id]
     * @Return IPage<ProjectDutyLetterVO>
     */
    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectDutyLetterVO>> queryList(@RequestBody QueryParam param, HttpServletRequest request) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dutyLetterName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("economicPersonName");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
	    param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, orgIds));
	    param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ProjectDutyLetterEntity> page = projectDutyLetterService.queryPage(param,false);
        IPage<ProjectDutyLetterVO> voPage = null;
        if(page!=null){
            voPage = new Page<>();
            voPage.setCurrent(page.getCurrent());
            voPage.setPages(page.getPages());
            voPage.setTotal(page.getTotal());
            voPage.setSize(param.getPageSize());
            voPage.setRecords(BeanMapper.mapList(page.getRecords(),ProjectDutyLetterVO.class));
        }
        return CommonResponse.success("查询列表数据成功！",voPage);
    }
    
    /**
     * @Author liyongjia
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterVO> vos) {
    	projectDutyLetterService.removeByIds(vos.stream().map(ProjectDutyLetterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Author liyongjia
     * @Date 2021/7/22 费用清单
     * @Description queryDetail
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryCostDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryCostDetail(Long id, HttpServletRequest request) {
        QueryParam param = new QueryParam();
        param.getParams().put("dutyLetterId",new Parameter(QueryParam.EQ,id));
        List<ProjectDutyLetterCostlistEntity> list = projectDutyLetterCostlistService.queryList(param, false);
        //累计扣除
        BigDecimal allDelete = new BigDecimal(0);
        //累计返还
        BigDecimal allAdd = new BigDecimal(0);
        //累计结余
        BigDecimal amount = new BigDecimal(0);
        if(list!=null&&list.size()>0){
            ProjectDutyLetterEntity entity = projectDutyLetterService.selectById(id);
            CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(entity.getProjectId());
            if(inAndOut.isSuccess()){
    			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
    			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
    				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
    			}
        		for(ProjectDutyLetterCostlistEntity cost : list){
					if (null==cost.getTaxCostId()) {
						if (cost.getFormula() != null) {
							String evalq = cost.getFormula();
							for (String key : dataresultIncoemAndExpend.keySet()) {
								String value = "0";
								value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
								evalq = evalq.replaceAll(key, value);
							}

							ScriptEngineManager manager = new ScriptEngineManager();
							ScriptEngine se = manager.getEngineByName("js");
							BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
							} catch (ScriptException e) {
								e.printStackTrace();
							}
							cost.setAmount(money);
						} else {
							cost.setAmount(new BigDecimal(0));
						}
					}
					if ("del".equals(cost.getBackOrDel())) {
						allDelete=ComputeUtil.safeAdd(allDelete,cost.getAmount());
					} else {
						allAdd=ComputeUtil.safeAdd(allAdd,cost.getAmount());
					}
        		}
            }
        }
        amount = allDelete.subtract(allAdd);
        JSONObject result = new JSONObject();
        result.put("id", id);
        result.put("projectDutyLetterCostList", list);
        result.put("allDelete", allDelete);
        result.put("allAdd", allAdd);
        result.put("amount", amount);
        return CommonResponse.success("查询详情数据成功！",result);
    }
    
    /**
     * @Author liyongjia
     * @Date 2021/7/26 管理费
     * @Description 
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryManageDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryManageDetail(@RequestParam Long id) {
        JSONObject result = new JSONObject();
    	ProjectDutyLetterEntity entity = projectDutyLetterService.selectById(id);
    	Long projectId = entity.getProjectId();
    	CommonResponse<List<ReceiveVO>> receiveReturn = receiveManageApi.queryList(projectId);
		if(receiveReturn.isSuccess()){
			List<ReceiveVO> receiveList = receiveReturn.getData();
    		//工程合同收款
            BigDecimal projectContractCollection = new BigDecimal(0);
            //管理费
            BigDecimal management = new BigDecimal(0);
            if(receiveList!=null&&receiveList.size()>0){
                for(ReceiveVO vo : receiveList){
                	vo.setContractMny(new BigDecimal(0));//这个字段存放管理费
                	if(vo.getReceiveMny()!=null){
                		projectContractCollection = projectContractCollection.add(vo.getReceiveMny());
                    	if(entity.getManagementExpense()!=null){
                    		vo.setContractMny(vo.getReceiveMny().multiply((entity.getManagementExpense().divide(new BigDecimal(100)))));
                    	}
                    	management = management.add(vo.getContractMny());
                	}
                }
            }
            
            result.put("id", id);
            result.put("receiveList", receiveList);
            result.put("projectContractCollection", projectContractCollection);//工程合同收款
            result.put("managementExpense", entity.getManagementExpense());//管理费比例
            result.put("management", management);//管理费
    	}else{
    		return CommonResponse.error(receiveReturn.getMsg());
    	}
        
        return CommonResponse.success("查询详情数据成功！",result);
    }

	/**
	 * @Author liyongjia
	 * @Date 2021/7/26 管理费
	 * @Description
	 * @Param [id]
	 * @Return
	 */
	@RequestMapping(value = "queryManageDetailForTax", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryManageDetailForTax(@RequestParam Long id) {
		JSONObject result = new JSONObject();
		ProjectDutyLetterEntity entity = projectDutyLetterService.selectById(id);
		Long projectId = entity.getProjectId();
		CommonResponse<InvoiceOpenRecordVO> invoiceOpenList = invoiceApi.getInvoiceOpenForProjectId(projectId);
		if(invoiceOpenList.isSuccess()){
			InvoiceOpenRecordVO data = invoiceOpenList.getData();
			//工程合同收款
			BigDecimal projectContractCollection = new BigDecimal(0);
			//管理费
			BigDecimal management = new BigDecimal(0);
			if(data.getInvoiceOpenVOList()!=null&&data.getInvoiceOpenVOList().size()>0){
				for(InvoiceOpenVO vo : data.getInvoiceOpenVOList()){
					vo.setUseInvoiceTaxMny(new BigDecimal(0));//这个字段存放管理费
					if(vo.getInvoiceTaxMny()!=null){
						projectContractCollection = ComputeUtil.safeAdd(projectContractCollection,vo.getInvoiceTaxMny());
						if(entity.getManagementExpense()!=null){
							vo.setUseInvoiceTaxMny(vo.getInvoiceTaxMny().multiply((entity.getManagementExpense().divide(new BigDecimal(100)))));
						}
						management = management.add(vo.getUseInvoiceTaxMny());
					}
				}
			}

			result.put("id", id);
			result.put("invoiceList", data.getInvoiceOpenVOList());
			result.put("invoiceTaxMny", null!=data.getInvoiceTaxMny()?data.getInvoiceTaxMny():0);//开票金额
			result.put("managementExpense", entity.getManagementExpense());//管理费比例
			result.put("management", management);//管理费
		}else{
			return CommonResponse.error(invoiceOpenList.getMsg());
		}

		return CommonResponse.success("查询详情数据成功！",result);
	}

    /**
     * @Author liyongjia
     * @Date 2020/7/26 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("economicPersonName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");

        /** 数据隔离 本下 */
        queryParam.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<ProjectDutyLetterEntity> list = projectDutyLetterService.queryList(queryParam,false);
        List<ProjectDutyLetterExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
        	ProjectDutyLetterExportVO exportVO = BeanMapper.map(vo, ProjectDutyLetterExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getCreateTime()));
            if(vo.getSigningDate()!=null){
            	exportVO.setSigningDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getSigningDate()));//签订日期
			}
            if(StringUtils.isNotBlank(vo.getChangeState())){
            	if(ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_UNCHANGED.equals(vo.getChangeState())){
            		exportVO.setChangeState("未变更");
				}else if(ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_CHANGING.equals(vo.getChangeState())){
					exportVO.setChangeState("变更中");
				}else if(ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_CHANGED.equals(vo.getChangeState())){
					exportVO.setChangeState("已变更");
				}else{
					exportVO.setChangeState("未变更");
				}
			}else{
				exportVO.setChangeState("未变更");
			}
            //经办人
            if(vo.getOperator()!=null){
        		try {
					JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getOperator().toString(), "idm-user");
					if(jArray!=null&&jArray.size()>0){
						JSONObject json = (JSONObject) jArray.get(0);
						exportVO.setOperatorName(json.get("name").toString());
					}
        		} catch (Exception e) {
        			e.printStackTrace();
        		}
			}
            //责任书状态
            if(StringUtils.isNotBlank(vo.getDutyLetterState())){
            	if("1".equals(vo.getDutyLetterState())){
            		exportVO.setDutyLetterState("未签订");
				}else if("2".equals(vo.getDutyLetterState())){
					exportVO.setDutyLetterState("履约中");
				}else if("3".equals(vo.getDutyLetterState())){
					exportVO.setDutyLetterState("已封账");
				}else{
					exportVO.setDutyLetterState("未签订");
				}
			}else{
				exportVO.setDutyLetterState("未签订");
			}
            if(exportVO.getManagementExpense()!=null){
            	exportVO.setManagementExpenseName(exportVO.getManagementExpense()+"%");
            }
			exportVO.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        String fileName = "projectDutyLetter-export.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }
   
    /**
     * @Author liyongjia
     * @Date 2020/8/05 更新费用清单金额
     * @Description updateCostList
     * @Param [projectIds]
     * @Return
     */
    @SuppressWarnings("unchecked")
	@RequestMapping(value = "updateCostList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateCostList(@RequestBody Map<String,Object> params) {
    	List<Long> projectIds = null;
    	if(params.get("projectIds")!=null){
        	projectIds = (List<Long>) params.get("projectIds");
    	}
    	List<ProjectDutyLetterCostlistEntity> costList = null;
		Long tenantid = InvocationInfoProxy.getTenantid();
		if(CollectionUtils.isEmpty(projectIds)){
			//查询责任书全部数据
    		costList = projectDutyLetterCostlistService.getCostListByProjectIds(null,tenantid);
            if(costList!=null&&costList.size()>0){
            	projectIds = new ArrayList<>();
            	for(ProjectDutyLetterCostlistEntity enetity : costList){
            		if(!projectIds.contains(enetity.getProjectId())){
            			projectIds.add(enetity.getProjectId());
            		}
            	}
            }else{
            	return CommonResponse.success("无项目更新");
            }
    	}else{
    		costList = projectDutyLetterCostlistService.getCostListByProjectIds(projectIds,tenantid);
    	}
    	CommonResponse<Map<Long, JSONObject>> incoemdataResult = iProjectBoardApi.queryIncoemAndExpendByProjectIds(projectIds);
    	if(incoemdataResult.isSuccess()){
    		for(ProjectDutyLetterCostlistEntity cost : costList) {
				if (null == cost.getTaxCostId()) {
					JSONObject dataresultIncoemAndExpend = incoemdataResult.getData().get(cost.getProjectId());
					if (dataresultIncoemAndExpend.get("incomeTaxRate") != null) {
						dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
					}
					if (cost.getFormula() != null) {
						String evalq = cost.getFormula();
						for (String key : dataresultIncoemAndExpend.keySet()) {
							String value = "0";
							value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
							evalq = evalq.replaceAll(key, value);
						}

						ScriptEngineManager manager = new ScriptEngineManager();
						ScriptEngine se = manager.getEngineByName("js");
						BigDecimal money = new BigDecimal(0);
						try {
							money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
						} catch (ScriptException e) {
							e.printStackTrace();
						}
						cost.setAmount(money);
					} else {
						cost.setAmount(new BigDecimal(0));
					}
				}
			}
    		projectDutyLetterCostlistService.saveOrUpdateBatch(BeanMapper.mapList(costList, ProjectDutyLetterCostlistEntity.class), costList.size(), false);
    	}else{
    		throw new BusinessException("请求项目资金数据失败，"+incoemdataResult.getMsg());
    	}
    	return CommonResponse.success("更新成功");
    }
}
