package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.mapper.PrjLoanInterestMapper;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.vo.PrjLoanInterestSubVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 借款利息结算
 *
 * @author jxy
 *
 */
@Service("prjLoanInterestService")
public class PrjLoanInterestServiceImpl extends BaseServiceImpl<PrjLoanInterestMapper, PrjLoanInterestEntity> implements IPrjLoanInterestService {

    public SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    @Autowired
    private IPrjLoanInterestSubService prjLoanInterestSubService;

    /**
     * 查询当前项目最新的日期
     * @param projectId
     * @return
     */
    public Map<String, String> queryLatelyDate(Long projectId) {
        Map<String, String> resp = new HashMap<>();
        QueryWrapper<PrjLoanInterestEntity> query = new QueryWrapper<>();
        query.select("  max(handle_date) as handleDate  ");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if (null != data) {
            resp.put("latelyDate", df.format(data.get("handleDate")));
        }
        return resp;
    }

    @Override
    public Map<Long, String> queryLatelyDate4Settle(Long projectId) {
        List<PrjLoanInterestSubVO> detailList = baseMapper.queryLatelyDate4Settle(projectId);
        return detailList.stream()
                .collect(Collectors.toMap(
                        PrjLoanInterestSubVO::getLoanId, t -> df.format(t.getStartInterest()), (k1, k2) -> k2));
    }


}
