/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjAdvancePaymentEntity;
import com.ejianc.business.prjfinance.mapper.PrjAdvancePaymentMapper;
import com.ejianc.business.prjfinance.service.IPrjAdvancePaymentService;
import com.ejianc.business.prjfinance.vo.PrjAdvancePaymentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="prjAdvancePaymentService")
public class PrjAdvancePaymentServiceImpl
extends BaseServiceImpl<PrjAdvancePaymentMapper, PrjAdvancePaymentEntity>
implements IPrjAdvancePaymentService {
    @Override
    public Map<String, BigDecimal> sumPrjAdvancePayInfo(QueryParam queryParam) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        Map queryResult = null;
        QueryWrapper query = PrjAdvancePaymentServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{" sum(if(bill_type = 1, amount, 0)) as totalAdvancePayAmt, sum(if(bill_type = 2, amount, 0)) as totalBackAmt"});
        queryResult = super.getMap((Wrapper)query);
        if (null != queryResult) {
            resp.put("totalAdvancePayAmt", null != queryResult.get("totalAdvancePayAmt") ? new BigDecimal(queryResult.get("totalAdvancePayAmt").toString()) : BigDecimal.ZERO);
            resp.put("totalBackAmt", null != queryResult.get("totalBackAmt") ? new BigDecimal(queryResult.get("totalBackAmt").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("totalAdvancePayAmt", BigDecimal.ZERO);
            resp.put("totalBackAmt", BigDecimal.ZERO);
        }
        return resp;
    }

    @Override
    public Map<String, BigDecimal> getTotalPrjAdvancePayInfo(Long projectId) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{" sum(if(bill_type = 1, amount, 0)) as totalAdvancePayAmt, sum(if(bill_type = 2, amount, 0)) as totalBackAmt"});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.and(q -> (QueryWrapper)((QueryWrapper)q.or(qe -> (QueryWrapper)qe.eq((Object)"bill_state", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()))).or(qe -> (QueryWrapper)qe.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("totalAdvancePayAmt", null != data.get("totalAdvancePayAmt") ? new BigDecimal(data.get("totalAdvancePayAmt").toString()) : BigDecimal.ZERO);
            resp.put("totalBackAmt", null != data.get("totalBackAmt") ? new BigDecimal(data.get("totalBackAmt").toString()) : BigDecimal.ZERO);
            resp.put("remanentAdvancePayAmt", ((BigDecimal)resp.get("totalAdvancePayAmt")).subtract((BigDecimal)resp.get("totalBackAmt")));
        } else {
            resp.put("totalAdvancePayAmt", BigDecimal.ZERO);
            resp.put("totalBackAmt", BigDecimal.ZERO);
            resp.put("remanentAdvancePayAmt", BigDecimal.ZERO);
        }
        query = new QueryWrapper();
        query.select(new String[]{"sum(amount) as totalBackAmt"});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"bill_type", (Object)"2");
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("remremainingRefundableAmt", null != data.get("totalBackAmt") ? new BigDecimal(data.get("totalBackAmt").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("remremainingRefundableAmt", BigDecimal.ZERO);
        }
        resp.put("remremainingRefundableAmt", ((BigDecimal)resp.get("totalAdvancePayAmt")).subtract((BigDecimal)resp.get("remremainingRefundableAmt")));
        return resp;
    }

    @Override
    public PrjAdvancePaymentVO getLastBillAccInfo(Long projectId, String billType) {
        PrjAdvancePaymentVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.and(q -> (QueryWrapper)((QueryWrapper)q.or(qe -> (QueryWrapper)qe.eq((Object)"bill_state", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()))).or(qe -> (QueryWrapper)qe.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode())));
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.orderByDesc((Object)"create_time");
        query.last("limit 1");
        PrjAdvancePaymentEntity e = (PrjAdvancePaymentEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (PrjAdvancePaymentVO)BeanMapper.map((Object)((Object)e), PrjAdvancePaymentVO.class);
        }
        return resp;
    }
}

