package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeClauseVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterRecordCostlistVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/**
 * @Author liyongjia
 * @Date 2021/7/21
 * @Description
 */

@RestController
@RequestMapping("/projectDutyLetterChange/")
public class ProjectDutyLetterChangeController {
	private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterChangeController.class);

    @Autowired
    IProjectDutyLetterChangeService projectDutyLetterChangeService;
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;
    /**
     * 责任书变更保存/更新
     *
     * @param projectDutyLetterChangeVO
     * @return
     */
    @PostMapping("saveOrUpdate")
    public CommonResponse<ProjectDutyLetterChangeVO> save(@RequestBody ProjectDutyLetterChangeVO projectDutyLetterChangeVO) {
        //查询变更责任书是否已有处在变更中的变更记录
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_id", new Parameter(QueryParam.EQ, projectDutyLetterChangeVO.getBillId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.PASSED_STATE.getBillStateCode()));

        queryParam.getParams().put("id", new Parameter(QueryParam.NE, projectDutyLetterChangeVO.getId()));
        List<ProjectDutyLetterChangeEntity> list = projectDutyLetterChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("保存失败，当前项目责任书存在未审批通过的变更记录！");
        }
        
        this.codeCheck(projectDutyLetterChangeVO.getBillId(), projectDutyLetterChangeVO.getBillCode());
        
        ProjectDutyLetterChangeVO resp = projectDutyLetterChangeService.save(projectDutyLetterChangeVO);
        return CommonResponse.success("保存成功！", resp);
    }

    public void codeCheck(Long id, String billCode) {
        if (StringUtils.isNotBlank(billCode)) {
            LambdaQueryWrapper<ProjectDutyLetterEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ProjectDutyLetterEntity::getTenantId, InvocationInfoProxy.getTenantid());
            wrapper.ne(id != null, ProjectDutyLetterEntity::getId, id);
            wrapper.eq(ProjectDutyLetterEntity::getBillCode, billCode);
            if (projectDutyLetterService.count(wrapper) > 0) {
                //已存在，不允许修改
                throw new BusinessException("编码已存在，请重新修改");
            }
        }
    }

    /**
     * 项目责任书变更详情查询
     *
     * @param id
     * @return
     */
    @GetMapping("queryDetail")
    public CommonResponse<ProjectDutyLetterChangeVO> detail(@RequestParam(value = "id", required=false) Long id,
    		@RequestParam(value = "dutyLetterId", required=false) Long dutyLetterId) {
    	ProjectDutyLetterChangeVO vo = null;
        if(id!=null&&id!=111){
        	ProjectDutyLetterChangeEntity e = projectDutyLetterChangeService.selectById(id);
            vo = BeanMapper.map(e, ProjectDutyLetterChangeVO.class);
        }else if(dutyLetterId!=null){
        	//新增变更初始化数据
        	ProjectDutyLetterEntity e = projectDutyLetterService.selectById(dutyLetterId);
            vo = BeanMapper.map(e, ProjectDutyLetterChangeVO.class);
            vo.setBillId(e.getId());
            vo.setId(null);
            vo.setCreateTime(null);
            vo.setCreateUserCode(null);
            vo.setCreateUserName(null);
            vo.setUpdateTime(null);
            vo.setUpdateUserCode(null);
            vo.setTenantId(null);
            vo.setBillState(0);
            if(e.getProjectDutyLetterClauseList()!=null&&e.getProjectDutyLetterClauseList().size()>0){
            	List<ProjectDutyLetterChangeClauseVO> items = new ArrayList<>();
            	for(ProjectDutyLetterClauseEntity item : e.getProjectDutyLetterClauseList()){
            		ProjectDutyLetterChangeClauseVO v = BeanMapper.map(item, ProjectDutyLetterChangeClauseVO.class);
            		v.setRowState("add");
            		items.add(v);
            	}
            	vo.setProjectDutyLetterChangeClauseList(items);
            }
            if(e.getProjectDutyLetterCostList()!=null&&e.getProjectDutyLetterCostList().size()>0){
            	List<ProjectDutyLetterChangeCostlistVO> items = new ArrayList<>();
            	for(ProjectDutyLetterCostlistEntity item : e.getProjectDutyLetterCostList()){
            		ProjectDutyLetterChangeCostlistVO v = BeanMapper.map(item, ProjectDutyLetterChangeCostlistVO.class);
            		v.setRowState("add");
            		items.add(v);
            	}
            	vo.setProjectDutyLetterChangeCostList(items);
            }
        }
        CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectDutyLetterChangeCostList()!=null&&vo.getProjectDutyLetterChangeCostList().size()>0){
        		List<ProjectDutyLetterChangeCostlistVO> list = vo.getProjectDutyLetterChangeCostList();
        		for(ProjectDutyLetterChangeCostlistVO cost : list) {
                    if (null == cost.getTaxCostId()) {
                        if (cost.getFormula() != null) {
                            String evalq = cost.getFormula();
                            for (String key : dataresultIncoemAndExpend.keySet()) {
                                String value = "0";
                                value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                                evalq = evalq.replaceAll(key, value);
                            }

                            ScriptEngineManager manager = new ScriptEngineManager();
                            ScriptEngine se = manager.getEngineByName("js");
                            BigDecimal money = new BigDecimal(0);
                            try {
                                money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
                            } catch (ScriptException e) {
                                e.printStackTrace();
                            }
//    					if("del".equals(cost.getBackOrDel())){
//    						money = new BigDecimal(0).subtract(money);
//    					}
                            cost.setAmount(money);
                        } else {
                            cost.setAmount(new BigDecimal(0));
                        }
                    }
                }
        	}
        }
        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 项目责任书变更删除
     *
     * @param vos
     * @return
     */
    @PostMapping("delete")
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterChangeVO> vos) {
        projectDutyLetterChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success("删除成功！");
    }
}
