package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prjfinance.mapper.PrjLoanInterestSubMapper;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestSubEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 借款利息结算子表
 * 
 * @author generator
 * 
 */
@Service("prjLoanInterestSubService")
public class PrjLoanInterestSubServiceImpl extends BaseServiceImpl<PrjLoanInterestSubMapper, PrjLoanInterestSubEntity> implements IPrjLoanInterestSubService{

    /**
     * 查询项目总利息
     * @param projectId
     * @return
     */
    public Map<String, BigDecimal> queryCurrentInterest(Long projectId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<PrjLoanInterestSubEntity> query = new QueryWrapper<>();
        query.select("  sum(principal_interest) as totalPrincipalInterest  ");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalPrincipalInterest", null != data.get("totalPrincipalInterest") ? new BigDecimal(data.get("totalPrincipalInterest").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalPrincipalInterest", BigDecimal.ZERO);
        }
        return resp;
    }

    /**
     * 修改借款金额
     * @param id
     * @param loanMoney
     * @param type
     */
   /* public void updateLoanMoney(Long id,BigDecimal loanMoney,int type){
        if(loanMoney==null){
            loanMoney = BigDecimal.ZERO;
        }
        PrjLoanInterestSubEntity entity = selectById(id);
        if(entity == null){
            throw new BusinessException("不存在的单据！");
        }
        if(loanMoney!=null){
            if(type == IPrjLoanInterestSubService.subtract){
                entity.setLoanMoney(entity.getLoanMoney()==null?loanMoney.multiply(new BigDecimal("-1")):entity.getLoanMoney().subtract(loanMoney));
            }else {
                entity.setLoanMoney(entity.getLoanMoney()==null?loanMoney:entity.getLoanMoney().add(loanMoney));
            }
            saveOrUpdate(entity);
        }
    }*/
}
