/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestSubEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prjLoanInterest")
public class PrjLoanInterestBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPrjLoanInterestService prjLoanInterestService;
    @Autowired
    private IProjectLoanService iProjectLoanService;
    @Autowired
    private IPrjLoanInterestSubService prjLoanInterestSubService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PrjLoanInterestEntity entity = (PrjLoanInterestEntity)((Object)this.prjLoanInterestService.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<PrjLoanInterestSubEntity> subEntities = entity.getLoanInterestSubEntities();
        if (ListUtil.isNotEmpty(subEntities)) {
            for (PrjLoanInterestSubEntity subEntity : subEntities) {
                this.iProjectLoanService.updateBillAllInterestMoney(subEntity.getLoanId(), subEntity.getPrincipalInterest(), 1);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PrjLoanInterestEntity main = (PrjLoanInterestEntity)((Object)this.prjLoanInterestService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)main.getProjectId()));
        param.getOrderMap().put("handleDate", "desc");
        param.getOrderMap().put("createTime", "desc");
        List list = this.prjLoanInterestService.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && !billId.equals(((PrjLoanInterestEntity)((Object)list.get(0))).getId())) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6700\u65b0\u5df2\u5ba1\u6838\u5355\u636e\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5"));
        list = this.prjLoanInterestService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)"\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PrjLoanInterestEntity main = (PrjLoanInterestEntity)((Object)this.prjLoanInterestService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<PrjLoanInterestSubEntity> subEntities = main.getLoanInterestSubEntities();
        if (ListUtil.isNotEmpty(subEntities)) {
            for (PrjLoanInterestSubEntity subEntity : subEntities) {
                this.iProjectLoanService.updateBillAllInterestMoney(subEntity.getLoanId(), subEntity.getPrincipalInterest(), 2);
            }
        }
        return CommonResponse.success();
    }
}

