package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordEntity;
import com.ejianc.business.prjfinance.mapper.ProjectDutyLetterChangeMapper;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("projectDutyLetterChangeService")
public class ProjectDutyLetterChangeService extends BaseServiceImpl<ProjectDutyLetterChangeMapper, ProjectDutyLetterChangeEntity> implements IProjectDutyLetterChangeService {

    private final String DEFAULT_RULE_CODE = "projectDutyLetter";

    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectDutyLetterRecordService projectDutyLetterRecordService;

    @Autowired
    private IBillCodeApi billCodeApi;


    @Override
    public ProjectDutyLetterChangeVO save(ProjectDutyLetterChangeVO projectDutyLetterChangeVO) {
        ProjectDutyLetterEntity dutyLetterEntity = projectDutyLetterService.selectById(projectDutyLetterChangeVO.getBillId());
        ProjectDutyLetterChangeEntity saveEntity = null;
        UserContext userContext = sessionManager.getUserContext();

        if(StringUtils.isBlank(projectDutyLetterChangeVO.getBillCode())) {
            //自动生成编码
            projectDutyLetterChangeVO.setBillCode(getAutoCode());
        }
        Boolean add = false;
        if(null == projectDutyLetterChangeVO.getId()) {
            //新增
            //设置变更版本
//            projectDutyLetterChangeVO.setChangeVersion(dutyLetterEntity.getChangeVersion()!=null?(dutyLetterEntity.getChangeVersion()+1):1);
            projectDutyLetterChangeVO.setId(IdWorker.getId());
            projectDutyLetterChangeVO.setCreateUserName(userContext.getUserName());
            add = true;
        }

        //保存-更新
        saveEntity = BeanMapper.map(projectDutyLetterChangeVO, ProjectDutyLetterChangeEntity.class);

        super.saveOrUpdate(saveEntity, false);

        //回写责任书数据
        if(add) {
            dutyLetterEntity.setChangeCode(saveEntity.getBillCode());
            dutyLetterEntity.setChangeState(ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_CHANGING);
            dutyLetterEntity.setChangeId(saveEntity.getId());
            dutyLetterEntity.setChangeVersion(dutyLetterEntity.getChangeVersion()!=null?(dutyLetterEntity.getChangeVersion()+1):1);
        }
        dutyLetterEntity.setChangeReason(saveEntity.getChangeReason());
        projectDutyLetterService.saveOrUpdate(dutyLetterEntity, false);

        return BeanMapper.map(saveEntity, ProjectDutyLetterChangeVO.class);
    }

    /**
     * 获取自动生成编码并校验重复
     *
     * @return
     */
    private String getAutoCode() {
        String code = null;
        while (StringUtils.isBlank(code)) {
            CommonResponse<String> resp = billCodeApi.getCodeBatchByRuleCode(DEFAULT_RULE_CODE, InvocationInfoProxy.getTenantid());
            if(!resp.isSuccess()) {
                throw new BusinessException("保存合同变更信息失败，自动生成编码失败！");
            }
            boolean checkResult = this.codeCheck(resp.getData());
            if(checkResult) {
                code = resp.getData();
            }
        }

        return code;
    }

    public boolean codeCheck(String billCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billCode", new Parameter(QueryParam.EQ,billCode));
        List<ProjectDutyLetterEntity> list = projectDutyLetterService.queryList(queryParam, false);
        if(list!=null&&list.size()>0){
            return false;
        }
        return  true;
    }


    @Override
    public void deleteById(Long id, boolean b) {
        ProjectDutyLetterChangeEntity e = super.selectById(id);
        if(!BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState())) {
            throw new BusinessException("删除失败，只能删除自由态的变更数据！");
        }
        String changeState = ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_UNCHANGED;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_id", new Parameter(QueryParam.EQ, e.getBillId()));
        List<ProjectDutyLetterRecordEntity> changeRecords = projectDutyLetterRecordService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(changeRecords)) {
            changeState = ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_CHANGED;
        }

        //责任书字段还原
        ProjectDutyLetterEntity dutyLetterEntity = projectDutyLetterService.selectById(e.getBillId());
        dutyLetterEntity.setChangeState(changeState);
        dutyLetterEntity.setChangeId(null);
        dutyLetterEntity.setChangeCode(null);
        dutyLetterEntity.setChangeReason(null);
        dutyLetterEntity.setChangeVersion(dutyLetterEntity.getChangeVersion()!=null?(dutyLetterEntity.getChangeVersion()-1):0);

        projectDutyLetterService.saveOrUpdate(dutyLetterEntity, false);
        super.removeById(id, false);
    }
}
