package com.ejianc.business.prjfinance.service;

import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface IProjectDutyLetterService extends IBaseService<ProjectDutyLetterEntity> {

    /**
     * 根据项目Id查询对应的目标责任书
     *
     * @param projectId
     * @return
     */
    ProjectDutyLetterEntity selectByPrjojectId(Long projectId);

    /**
     * 根据项目Id查询对应的联营项目费用列表
     */
    List<OperationCostVO> getOperationList(OperationCostVO operationCostVO);

    List<OperationCostVO> getOperationList4Org();
}
