package com.ejianc.business.bid.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BidStatusEnum {
    投标中(0,"投标中"),
    中标(1,"中标"),
    未中标(2,"未中标"),
    已中止(3,"已中止"),
    预审不通过 (4,"预审不通过");
    BidStatusEnum(Integer typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    private Integer typeCode;
    private String typeName;
    private static Map<Integer, BidStatusEnum> enumMap = new HashMap<>();

    public Integer getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(Integer typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(BidStatusEnum.class).stream().collect(Collectors.toMap(BidStatusEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static BidStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
