/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.back.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.back.bean.BackEntity;
import com.ejianc.business.back.service.IBackService;
import com.ejianc.business.pay.bean.PayBackRecordEntity;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.service.IPayBackRecordService;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="back")
public class BackBpmServiceImpl
implements ICommonBusinessService {
    private final IBackService service;
    private final IPayService payService;
    private final IPayBackRecordService payBackRecordService;
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BackBpmServiceImpl(IBackService service, IPayService payService, IPayBackRecordService payBackRecordService, SessionManager sessionManager, IBillTypeApi billTypeApi) {
        this.service = service;
        this.payService = payService;
        this.payBackRecordService = payBackRecordService;
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        BackEntity entity = (BackEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        PayBackRecordEntity payBackRecord = this.convertToPayBackRecord(entity);
        PayEntity pay = (PayEntity)((Object)this.payService.selectById(entity.getSourceBondPayId()));
        List<PayBackRecordEntity> payBackRecordList = pay.getPayBackRecordList();
        if (CollectionUtils.isNotEmpty(payBackRecordList)) {
            BigDecimal totalBackMny = payBackRecordList.stream().map(PayBackRecordEntity::getSourceBackMny).reduce(payBackRecord.getSourceBackMny(), BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            pay.setBackMny(totalBackMny);
        } else {
            pay.setBackMny(entity.getCurBackMny());
        }
        pay.setRemainMny(pay.getPayMny().subtract(pay.getBackMny()).setScale(2, RoundingMode.HALF_UP));
        payBackRecordList.add(payBackRecord);
        this.payService.saveOrUpdate((Object)pay, false);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        BackEntity entity = (BackEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"bond_pay_id", (Object)entity.getSourceBondPayId());
        qw.eq((Object)"source_bond_back_id", (Object)entity.getId());
        this.payBackRecordService.remove((Wrapper)qw);
        PayEntity pay = (PayEntity)((Object)this.payService.selectById(entity.getSourceBondPayId()));
        List<PayBackRecordEntity> payBackRecordList = pay.getPayBackRecordList();
        if (CollectionUtils.isNotEmpty(payBackRecordList)) {
            BigDecimal totalBackMny = payBackRecordList.stream().map(PayBackRecordEntity::getSourceBackMny).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            pay.setBackMny(totalBackMny);
        } else {
            pay.setBackMny(BigDecimal.ZERO);
        }
        pay.setRemainMny(pay.getPayMny().subtract(pay.getBackMny()).setScale(2, RoundingMode.HALF_UP));
        this.payService.saveOrUpdate((Object)pay, false);
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de\u6210\u529f");
    }

    private PayBackRecordEntity convertToPayBackRecord(BackEntity entity) {
        PayBackRecordEntity pbr = new PayBackRecordEntity();
        pbr.setSourceEmployeeId(entity.getEmployeeId());
        pbr.setSourceEmployeeName(entity.getEmployeeName());
        pbr.setCommitDate(entity.getCommitDate());
        pbr.setCommitUserName(entity.getCommitUserName());
        pbr.setCommitUserCode(entity.getCommitUserCode());
        pbr.setEffectiveDate(new Date());
        pbr.setBillCode(entity.getBillCode());
        pbr.setBillName(entity.getBillName());
        pbr.setBillType(entity.getBillType());
        pbr.setBillState(entity.getBillState());
        pbr.setBillStateName(entity.getBillStateName());
        pbr.setSourceBondBackId(entity.getId());
        pbr.setSourceBillCode(entity.getBillCode());
        pbr.setSourceBillName(entity.getBillName());
        pbr.setSourceBackMny(entity.getCurBackMny());
        pbr.setSourceBackDate(entity.getBackDate());
        pbr.setSourceBackMemo(entity.getMemo());
        pbr.setBondPayId(entity.getSourceBondPayId());
        return pbr;
    }
}

