/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.enums.BidStatusEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.vo.ProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"project"})
public class ProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "QTF_CODE";
    @Autowired
    private IProjectService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectVO> saveOrUpdate(@RequestBody ProjectVO saveOrUpdateVO) {
        ProjectEntity entity = (ProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if ("2".equals(entity.getProjectInitType())) {
                entity.setBidStatus(BidStatusEnum.\u672a\u4e2d\u6807.getTypeName());
            } else {
                entity.setBidStatus(BidStatusEnum.\u6295\u6807\u4e2d.getTypeName());
            }
            entity.setRegistDataFlag(0);
            entity.setPrequalificationFlag(0);
            entity.setWinFlag(0);
            entity.setOpenFlag(0);
            entity.setReviewFlag(0);
            entity.setPayFlag(0);
            entity.setCalcFlag(0);
            entity.setRecordFlag(0);
            entity.setTenderFlag(0);
            if (entity.getBusinessId() != null) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ArrayList<Integer> billState = new ArrayList<Integer>();
                billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                queryWrapper.eq((Object)"business_id", (Object)entity.getBusinessId());
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.notIn((Object)"bill_state", billState);
                int countReg = this.service.count((Wrapper)queryWrapper);
                if (countReg > 0) {
                    throw new BusinessException("\u5f53\u524d\u5546\u673a\u4e0b \u6709\u672a\u751f\u6548\u7684\u5355\u636e!");
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectVO vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectVO> queryDetail(Long id) {
        ProjectEntity entity = (ProjectEntity)((Object)this.service.selectById(id));
        ProjectVO vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectVO projectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("bidUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(orgId);
        if (!childrenByParentId.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)childrenByParentId.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)childrenByParentId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("bidUnitName");
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(orgId);
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)childrenByParentId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList vos = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        list.forEach(e -> {
            ProjectVO vo = (ProjectVO)BeanMapper.map((Object)e, ProjectVO.class);
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            vo.setCreateTimeStr(sdf.format(vo.getCreateTime()));
            vo.setBidOpenDateStr(sdf.format(vo.getBidOpenDate()));
            vo.setRegistrationDeadlineStr(sdf.format(vo.getRegistrationDeadline()));
            vos.add(vo);
        });
        beans.put("records", vos);
        ExcelExport.getInstance().export("Project-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("applyUserId");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidUnitName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("bidUnitId")) {
                CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.valueOf(_con.getString("bidUnitId"))));
                if (!childrenByParentId.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)childrenByParentId.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("bid_unit_id", new Parameter("in", ((List)childrenByParentId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            if (condition.contains("bidStatus")) {
                Integer bidStatus = Integer.valueOf(_con.getString("bidStatus"));
                param.getParams().put("bid_status", new Parameter("eq", (Object)BidStatusEnum.getByCode((Integer)bidStatus).getTypeName()));
            }
            if (condition.contains("tenderFlag")) {
                String tenderFlag = _con.getString("tenderFlag");
                param.getParams().put("tender_flag", new Parameter("eq", (Object)Integer.valueOf(tenderFlag)));
            }
            if (condition.contains("recordFlag")) {
                String recordFlag = _con.getString("recordFlag");
                param.getParams().put("record_flag", new Parameter("eq", (Object)Integer.valueOf(recordFlag)));
            }
            if (condition.contains("calcFlag")) {
                String calcFlag = _con.getString("calcFlag");
                param.getParams().put("calc_flag", new Parameter("eq", (Object)Integer.valueOf(calcFlag)));
            }
            if (condition.contains("payFlag")) {
                String payFlag = _con.getString("payFlag");
                param.getParams().put("pay_flag", new Parameter("eq", (Object)Integer.valueOf(payFlag)));
            }
            if (condition.contains("reviewFlag")) {
                String reviewFlag = _con.getString("reviewFlag");
                param.getParams().put("review_flag", new Parameter("eq", (Object)Integer.valueOf(reviewFlag)));
            }
            if (condition.contains("winFlag") && condition.contains("openFlag")) {
                String winFlag = _con.getString("winFlag");
                param.getParams().put("win_flag", new Parameter("eq", (Object)Integer.valueOf(winFlag)));
                String openFlag = _con.getString("openFlag");
                param.getParams().put("", new Parameter("sql", (Object)("(project_init_type = 0 and open_flag = " + Integer.valueOf(openFlag) + ") or project_init_type = 1")));
            }
            if (condition.contains("registDataFlag")) {
                String registDataFlag = _con.getString("registDataFlag");
                param.getParams().put("regist_data_flag", new Parameter("eq", (Object)registDataFlag));
            }
            if (condition.contains("prequalificationFlag")) {
                String prequalificationFlag = _con.getString("prequalificationFlag");
                param.getParams().put("prequalification_flag", new Parameter("eq", (Object)prequalificationFlag));
            }
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectVO.class));
        this.logger.info("records----{}", (Object)JSONObject.toJSONString((Object)page.get((Object)"records")));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

