/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.mapper.ProjectMapper;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.service.IRegisDataService;
import com.ejianc.business.bid.vo.ProjectVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectService")
public class ProjectServiceImpl
extends BaseServiceImpl<ProjectMapper, ProjectEntity>
implements IProjectService {
    @Autowired
    private IRegisDataService dataService;

    @Override
    public void updateBidStatus(ProjectVO entity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        if (entity.getBidStatus() != null) {
            updateWrapper.set(ProjectEntity::getBidStatus, (Object)entity.getBidStatus());
        }
        if (entity.getPrequalificationFlag() != null) {
            updateWrapper.set(ProjectEntity::getPrequalificationFlag, (Object)entity.getPrequalificationFlag());
        }
        if (entity.getRegistDataFlag() != null) {
            QueryWrapper registrationQuery = new QueryWrapper();
            if (entity.getMemo().equals("add")) {
                updateWrapper.set(ProjectEntity::getRegistDataFlag, (Object)entity.getRegistDataFlag());
            } else {
                ArrayList<Integer> billState = new ArrayList<Integer>();
                billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                registrationQuery.eq((Object)"project_id", (Object)entity.getId());
                registrationQuery.eq((Object)"dr", (Object)0);
                registrationQuery.in((Object)"bill_state", billState);
                int countReg = this.dataService.count((Wrapper)registrationQuery);
                if (countReg > 0) {
                    updateWrapper.set(ProjectEntity::getRegistDataFlag, (Object)1);
                } else {
                    updateWrapper.set(ProjectEntity::getRegistDataFlag, (Object)0);
                }
            }
        }
        if (entity.getTenderFlag() != null) {
            updateWrapper.set(ProjectEntity::getTenderFlag, (Object)entity.getTenderFlag());
        }
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateEffectFlag(Long projectId, String column, Integer effectFlag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)projectId);
        updateWrapper.set((Object)column, (Object)effectFlag);
        super.update((Wrapper)updateWrapper);
    }
}

