/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.win.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.enums.BidStatusEnum;
import com.ejianc.business.bid.enums.EffectFlagEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.business.win.bean.WinEntity;
import com.ejianc.business.win.service.IWinService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="win")
public class WinBpmServiceImpl
implements ICommonBusinessService {
    private final IWinService service;
    private final IProjectService projectService;
    private final IProcessService processService;
    private final SessionManager sessionManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public WinBpmServiceImpl(IWinService service, IProjectService projectService, IProcessService processService, SessionManager sessionManager) {
        this.service = service;
        this.projectService = projectService;
        this.processService = processService;
        this.sessionManager = sessionManager;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        WinEntity entity = (WinEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getProjectId());
        updateWrapper.set(ProjectEntity::getBidStatus, (Object)("0".equals(entity.getBidWinFlag()) ? BidStatusEnum.\u672a\u4e2d\u6807.getTypeName() : BidStatusEnum.\u4e2d\u6807.getTypeName()));
        updateWrapper.set(ProjectEntity::getWinFlag, (Object)EffectFlagEnum.EFFECT.getCode());
        this.projectService.update((Wrapper)updateWrapper);
        this.saveProcess(entity, "\u4e2d\u6807\u767b\u8bb0", "win/card");
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        WinEntity entity = (WinEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getProjectId());
        updateWrapper.set(ProjectEntity::getBidStatus, (Object)BidStatusEnum.\u6295\u6807\u4e2d.getTypeName());
        updateWrapper.set(ProjectEntity::getWinFlag, (Object)EffectFlagEnum.INVALID.getCode());
        this.projectService.update((Wrapper)updateWrapper);
        this.delProcess(entity.getId());
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de\u6210\u529f");
    }

    private void saveProcess(WinEntity entity, String billName, String frontendUrl) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(billName);
        processEntity.setProjectId(entity.getProjectId());
        processEntity.setProjectCode(entity.getProjectCode());
        processEntity.setProjectName(entity.getProjectName());
        processEntity.setFrontendUrl(frontendUrl);
        this.processService.saveOrUpdate((Object)processEntity);
    }

    private void delProcess(Long billId) {
        LambdaQueryWrapper l = new LambdaQueryWrapper();
        l.eq(ProcessEntity::getBillId, (Object)billId);
        this.processService.remove((Wrapper)l);
    }
}

