package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.BusinessEntity;
import com.ejianc.business.bid.bean.OtherFileDetailEntity;
import com.ejianc.business.bid.bean.OtherFileEntity;
import com.ejianc.business.bid.bean.TenderEntity;
import com.ejianc.business.bid.service.IOtherFileService;
import com.ejianc.business.bid.service.ITenderService;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

@Service("otherFile") 
public class OtherFileBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IOtherFileService service;
	@Autowired
	private IProcessService processService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success("其他附件，提交前回调成功");
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		OtherFileEntity entity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(entity, false);
		return CommonResponse.success("其他附件审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OtherFileEntity entity = service.selectById(billId);
		if (entity != null) {
			entity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			entity.setCommitDate(new Date());
			entity.setCommitUserCode(userContext.getUserCode());
			entity.setCommitUserName(userContext.getUserName());
		}
		service.saveOrUpdate(entity, false);
		saveProcess(entity, "其他附件", "other/card");

		return CommonResponse.success("其他附件终审回调成功");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		OtherFileEntity entity = service.selectById(billId);
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		delProcess(entity.getId());
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

	/**
	 * 新增投标记录
	 *
	 * @param entity      实体
	 * @param billName    单据名称
	 * @param frontendUrl 前端路由
	 */
	private void saveProcess(OtherFileEntity entity, String billName, String frontendUrl) {
		ProcessEntity processEntity = new ProcessEntity();
		processEntity.setBillId(entity.getId());
		processEntity.setBillName(billName);
		processEntity.setProjectId(entity.getProjectId());
		processEntity.setProjectCode(entity.getProjectCode());
		processEntity.setProjectName(entity.getProjectName());
		processEntity.setFrontendUrl(frontendUrl);
		processService.saveOrUpdate(processEntity);
	}

	/**
	 * 根据单据id删除对应投标流程记录
	 *
	 * @param billId 单据id
	 */
	private void delProcess(Long billId) {
		LambdaQueryWrapper<ProcessEntity> l = new LambdaQueryWrapper<>();
		l.eq(ProcessEntity::getBillId, billId);
		processService.remove(l);
	}
}
