package com.ejianc.business.review.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标文件评审实体
 *
 * @author generator
 */
@TableName("ejc_probid_bid_file_review")
public class ReviewEntity extends BaseEntity {
	private static final long serialVersionUID = -5808567191848893352L;

	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编码
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_type")
	private String billType; // 单据类型
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "construction_unit")
	private String constructionUnit; // 建设单位
	@TableField(value = "registration_deadline")
	private Date registrationDeadline; // 报名截止日期
	@TableField(value = "bid_open_date")
	private Date bidOpenDate; // 开标日期
	@TableField(value = "bid_unit_id")
	private Long bidUnitId; // 投标单位id
	@TableField(value = "bid_unit_code")
	private String bidUnitCode; // 投标单位编码
	@TableField(value = "bid_unit_name")
	private String bidUnitName; // 投标单位名称
	@TableField(value = "detailed_address")
	private String detailedAddress; // 工程地点(详细地址)
	@TableField(value = "tel_fax")
	private String telFax; // 电话传真
	@TableField(value = "bid_price")
	private BigDecimal bidPrice; // 投标报价
	@TableField(value = "structure_id")
	private Long structureId; // 结构id
	@TableField(value = "structure_code")
	private String structureCode; // 结构编码
	@TableField(value = "structure_name")
	private String structureName; // 结构名称
	@TableField(value = "project_total_area")
	private BigDecimal projectTotalArea; // 建筑面积
	@TableField(value = "contract_mode_id")
	private Long contractModeId; // 承包形式id
	@TableField(value = "contract_mode_code")
	private String contractModeCode; // 承包形式编码
	@TableField(value = "contract_mode_name")
	private String contractModeName; // 承包形式名称
	@TableField(value = "project_quality_id")
	private Long projectQualityId; // 工程质量id
	@TableField(value = "project_quality_code")
	private String projectQualityCode; // 工程质量编码
	@TableField(value = "project_quality_name")
	private String projectQualityName; // 工程质量名称
	@TableField(value = "project_duration")
	private Integer projectDuration; // 工期
	@TableField(value = "handle_date")
	private Date handleDate; // 办理日期
	@TableField(value = "source_bid_record_id")
	private Long sourceBidRecordId; // 工程投标备案id
	@TableField(value = "project_content_id")
	private String projectContentId; // 工程内容id
	@TableField(value = "project_content_code")
	private String projectContentCode; // 工程内容code
	@TableField(value = "project_content_name")
	private String projectContentName; // 工程内容name
	@TableField(value = "bid_flag")
	private Integer bidFlag; // 是否投标 0-否，1-是
	@TableField(value = "memo")
	private String memo; // 其他说明


	@TableField(exist = false)
	@SubEntity(serviceName = "reviewFundService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewFundEntity> reviewFundList = new ArrayList<>(); // 投标文件评审-资金情况实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentManageService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentManageEntity> reviewContentManageList = new ArrayList<>(); // 投标文件评审-评审内容-经营负责人实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentTechnologyService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentTechnologyEntity> reviewContentTechnologyList = new ArrayList<>(); // 投标文件评审-评审内容-技术负责人实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentBudgetService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentBudgetEntity> reviewContentBudgetList = new ArrayList<>(); // 投标文件评审-评审内容-预算负责人实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentFinanceService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentFinanceEntity> reviewContentFinanceList = new ArrayList<>(); // 投标文件评审-评审内容-财务负责人实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentDirectService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentDirectEntity> reviewContentDirectList = new ArrayList<>(); // 投标文件评审-评审内容-直管部 （分公司）负责人实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentBusinessService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentBusinessEntity> reviewContentBusinessList = new ArrayList<>(); // 投标文件评审-评审内容-经营部负责人实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentDeputyService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentDeputyEntity> reviewContentDeputyList = new ArrayList<>(); // 投标文件评审-评审内容-经营副总经理审核意见实体
	@TableField(exist = false)
	@SubEntity(serviceName = "reviewContentGmService", pidName = "bidFileReviewId")//此处有pid="xxx"，默认值pid="pid"
	private List<ReviewContentGmEntity> reviewContentGmList = new ArrayList<>(); // 投标文件评审-评审内容-总经理审批意见实体


	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getConstructionUnit() {
		return constructionUnit;
	}

	public void setConstructionUnit(String constructionUnit) {
		this.constructionUnit = constructionUnit;
	}

	public Date getRegistrationDeadline() {
		return registrationDeadline;
	}

	public void setRegistrationDeadline(Date registrationDeadline) {
		this.registrationDeadline = registrationDeadline;
	}

	public Date getBidOpenDate() {
		return bidOpenDate;
	}

	public void setBidOpenDate(Date bidOpenDate) {
		this.bidOpenDate = bidOpenDate;
	}

	public Long getBidUnitId() {
		return bidUnitId;
	}

	public void setBidUnitId(Long bidUnitId) {
		this.bidUnitId = bidUnitId;
	}

	public String getBidUnitCode() {
		return bidUnitCode;
	}

	public void setBidUnitCode(String bidUnitCode) {
		this.bidUnitCode = bidUnitCode;
	}

	public String getBidUnitName() {
		return bidUnitName;
	}

	public void setBidUnitName(String bidUnitName) {
		this.bidUnitName = bidUnitName;
	}

	public String getDetailedAddress() {
		return detailedAddress;
	}

	public void setDetailedAddress(String detailedAddress) {
		this.detailedAddress = detailedAddress;
	}

	public String getTelFax() {
		return telFax;
	}

	public void setTelFax(String telFax) {
		this.telFax = telFax;
	}

	public BigDecimal getBidPrice() {
		return bidPrice;
	}

	public void setBidPrice(BigDecimal bidPrice) {
		this.bidPrice = bidPrice;
	}

	public Long getStructureId() {
		return structureId;
	}

	public void setStructureId(Long structureId) {
		this.structureId = structureId;
	}

	public String getStructureCode() {
		return structureCode;
	}

	public void setStructureCode(String structureCode) {
		this.structureCode = structureCode;
	}

	public String getStructureName() {
		return structureName;
	}

	public void setStructureName(String structureName) {
		this.structureName = structureName;
	}

	public BigDecimal getProjectTotalArea() {
		return projectTotalArea;
	}

	public void setProjectTotalArea(BigDecimal projectTotalArea) {
		this.projectTotalArea = projectTotalArea;
	}

	public Long getContractModeId() {
		return contractModeId;
	}

	public void setContractModeId(Long contractModeId) {
		this.contractModeId = contractModeId;
	}

	public String getContractModeCode() {
		return contractModeCode;
	}

	public void setContractModeCode(String contractModeCode) {
		this.contractModeCode = contractModeCode;
	}

	public String getContractModeName() {
		return contractModeName;
	}

	public void setContractModeName(String contractModeName) {
		this.contractModeName = contractModeName;
	}

	public Long getProjectQualityId() {
		return projectQualityId;
	}

	public void setProjectQualityId(Long projectQualityId) {
		this.projectQualityId = projectQualityId;
	}

	public String getProjectQualityCode() {
		return projectQualityCode;
	}

	public void setProjectQualityCode(String projectQualityCode) {
		this.projectQualityCode = projectQualityCode;
	}

	public String getProjectQualityName() {
		return projectQualityName;
	}

	public void setProjectQualityName(String projectQualityName) {
		this.projectQualityName = projectQualityName;
	}

	public Integer getProjectDuration() {
		return projectDuration;
	}

	public void setProjectDuration(Integer projectDuration) {
		this.projectDuration = projectDuration;
	}

	public Date getHandleDate() {
		return handleDate;
	}

	public void setHandleDate(Date handleDate) {
		this.handleDate = handleDate;
	}

	public Long getSourceBidRecordId() {
		return sourceBidRecordId;
	}

	public void setSourceBidRecordId(Long sourceBidRecordId) {
		this.sourceBidRecordId = sourceBidRecordId;
	}

	public String getProjectContentId() {
		return projectContentId;
	}

	public void setProjectContentId(String projectContentId) {
		this.projectContentId = projectContentId;
	}

	public String getProjectContentCode() {
		return projectContentCode;
	}

	public void setProjectContentCode(String projectContentCode) {
		this.projectContentCode = projectContentCode;
	}

	public String getProjectContentName() {
		return projectContentName;
	}

	public void setProjectContentName(String projectContentName) {
		this.projectContentName = projectContentName;
	}

	public Integer getBidFlag() {
		return bidFlag;
	}

	public void setBidFlag(Integer bidFlag) {
		this.bidFlag = bidFlag;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public List<ReviewFundEntity> getReviewFundList() {
		return reviewFundList;
	}

	public void setReviewFundList(List<ReviewFundEntity> reviewFundList) {
		this.reviewFundList = reviewFundList;
	}

	public List<ReviewContentManageEntity> getReviewContentManageList() {
		return reviewContentManageList;
	}

	public void setReviewContentManageList(List<ReviewContentManageEntity> reviewContentManageList) {
		this.reviewContentManageList = reviewContentManageList;
	}

	public List<ReviewContentTechnologyEntity> getReviewContentTechnologyList() {
		return reviewContentTechnologyList;
	}

	public void setReviewContentTechnologyList(List<ReviewContentTechnologyEntity> reviewContentTechnologyList) {
		this.reviewContentTechnologyList = reviewContentTechnologyList;
	}

	public List<ReviewContentBudgetEntity> getReviewContentBudgetList() {
		return reviewContentBudgetList;
	}

	public void setReviewContentBudgetList(List<ReviewContentBudgetEntity> reviewContentBudgetList) {
		this.reviewContentBudgetList = reviewContentBudgetList;
	}

	public List<ReviewContentFinanceEntity> getReviewContentFinanceList() {
		return reviewContentFinanceList;
	}

	public void setReviewContentFinanceList(List<ReviewContentFinanceEntity> reviewContentFinanceList) {
		this.reviewContentFinanceList = reviewContentFinanceList;
	}

	public List<ReviewContentDirectEntity> getReviewContentDirectList() {
		return reviewContentDirectList;
	}

	public void setReviewContentDirectList(List<ReviewContentDirectEntity> reviewContentDirectList) {
		this.reviewContentDirectList = reviewContentDirectList;
	}

	public List<ReviewContentBusinessEntity> getReviewContentBusinessList() {
		return reviewContentBusinessList;
	}

	public void setReviewContentBusinessList(List<ReviewContentBusinessEntity> reviewContentBusinessList) {
		this.reviewContentBusinessList = reviewContentBusinessList;
	}

	public List<ReviewContentDeputyEntity> getReviewContentDeputyList() {
		return reviewContentDeputyList;
	}

	public void setReviewContentDeputyList(List<ReviewContentDeputyEntity> reviewContentDeputyList) {
		this.reviewContentDeputyList = reviewContentDeputyList;
	}

	public List<ReviewContentGmEntity> getReviewContentGmList() {
		return reviewContentGmList;
	}

	public void setReviewContentGmList(List<ReviewContentGmEntity> reviewContentGmList) {
		this.reviewContentGmList = reviewContentGmList;
	}
}
