package com.ejianc.business.bid.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.PrequalificationEntity;
import com.ejianc.business.bid.service.IPrequalificationService;
import com.ejianc.business.bid.vo.PrequalificationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 资格预审
 *
 * @author generator
 */
@Controller
@RequestMapping("prequalification")
public class PrequalificationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLF_CODE";//此处需要根据实际修改

    @Autowired
    private IPrequalificationService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrequalificationVO> saveOrUpdate(@RequestBody PrequalificationVO saveOrUpdateVO) {
        PrequalificationEntity entity = BeanMapper.map(saveOrUpdateVO, PrequalificationEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行

            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            int countReg = service.count(queryWrapper);
            if (countReg > 0) {
                throw new BusinessException("当前项目下 有自由态的单据!");
            }

        }
        service.saveOrUpdate(entity, false);
        PrequalificationVO vo = BeanMapper.map(entity, PrequalificationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrequalificationVO> queryDetail(Long id) {
        PrequalificationEntity entity = service.selectById(id);
        PrequalificationVO vo = BeanMapper.map(entity, PrequalificationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrequalificationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PrequalificationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PrequalificationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PrequalificationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("bidUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(orgId);
        if (!childrenByParentId.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", childrenByParentId.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<PrequalificationEntity> page = service.queryPage(param, false);
        IPage<PrequalificationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrequalificationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("bidUnitName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(orgId);

        param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PrequalificationEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<PrequalificationVO> vos = new ArrayList<>();
        list.forEach(e -> {
            PrequalificationVO vo = BeanMapper.map(e, PrequalificationVO.class);
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            vo.setEstimatedResultStr(vo.getEstimatedResult() == 0 ? "通过" : "不通过");
            vos.add(vo);
        });
        beans.put("records", vos);
        ExcelExport.getInstance().export("Prequalification-export.xlsx", beans, response);
    }


}
