package com.ejianc.business.process.controller;

import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 投标流程实体
 *
 * @author baipengyan
 */
@RestController
@RequestMapping("process")
public class ProcessController implements Serializable {
	private static final long serialVersionUID = 1456949515678425774L;

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	private final IProcessService service;

	public ProcessController(IProcessService service) {
		this.service = service;
	}

	/**
	 * 查询投标流程列表
	 *
	 * @param projectId 项目id
	 *
	 * @return 投标流程列表
	 */
	@GetMapping(value = "/queryProcess")
	public CommonResponse<LinkedHashMap<String, List<ProcessEntity>>> queryProcess(@RequestParam("projectId") Long projectId) {
		return CommonResponse.success("查询列表数据成功！", service.queryProcess(projectId));
	}

}
