/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.BusinessEntity;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.service.IBusinessService;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.vo.BusinessVO;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="project")
public class ProjectBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBusinessService businessService;
    @Autowired
    private IProcessService processService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u6295\u6807\u7acb\u9879\uff0c \u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectEntity terminateEntity = (ProjectEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        terminateEntity.setCommitDate(new Date());
        terminateEntity.setCommitUserCode(userContext.getUserCode());
        terminateEntity.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)terminateEntity, false);
        return CommonResponse.success((String)"\u6295\u6807\u4e2d\u6b62\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectEntity entity = (ProjectEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            entity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        if (entity.getBusinessId() != null) {
            BusinessVO vo = new BusinessVO();
            vo.setId(entity.getBusinessId());
            vo.setProjectCode(entity.getBillCode());
            vo.setProjectId(entity.getId());
            vo.setRefFlag(Integer.valueOf(1));
            this.businessService.updateRefFlag(vo);
            BusinessEntity businessEntity = (BusinessEntity)((Object)this.businessService.selectById(entity.getBusinessId()));
            this.businessService.saveProcess(businessEntity, "\u5546\u673a\u767b\u8bb0", "business/card");
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.saveProcess(entity, "\u6295\u6807\u7acb\u9879", "project/card");
        return CommonResponse.success((String)"\u6295\u6807\u7acb\u9879\u7ec8\u5ba1\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ProjectEntity entity = (ProjectEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (entity.getBusinessId() != null) {
            BusinessVO vo = new BusinessVO();
            vo.setId(entity.getBusinessId());
            vo.setProjectCode(entity.getBillCode());
            vo.setProjectId(entity.getId());
            vo.setRefFlag(Integer.valueOf(0));
            this.businessService.updateRefFlag(vo);
            this.businessService.delProcess(entity.getBusinessId());
        }
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        this.delProcess(entity.getId());
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    private void saveProcess(ProjectEntity entity, String billName, String frontendUrl) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(billName);
        processEntity.setProjectId(entity.getId());
        processEntity.setProjectCode(entity.getBillCode());
        processEntity.setProjectName(entity.getProjectName());
        processEntity.setFrontendUrl(frontendUrl);
        this.processService.saveOrUpdate((Object)processEntity);
    }

    private void delProcess(Long billId) {
        LambdaQueryWrapper l = new LambdaQueryWrapper();
        l.eq(ProcessEntity::getBillId, (Object)billId);
        this.processService.remove((Wrapper)l);
    }
}

