/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.review.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.review.bean.ReviewEntity;
import com.ejianc.business.review.service.IReviewService;
import com.ejianc.business.review.vo.ReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"review"})
public class ReviewController
implements Serializable {
    private static final long serialVersionUID = 3536444014220643625L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "PROBID_REVIEW";
    private static final String BILL_CODE = "EJCBT202207000021";
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IReviewService service;
    private final SessionManager sessionManager;

    public ReviewController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IReviewService service, SessionManager sessionManager) {
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
        this.sessionManager = sessionManager;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<ReviewVO> saveOrUpdate(@RequestBody ReviewVO saveOrUpdateVO) {
        ReviewEntity entity = (ReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReviewEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.service.checkOnlyOne(entity.getProjectId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1");
        entity.setBillType(BILL_CODE);
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        ReviewVO vo = (ReviewVO)BeanMapper.map((Object)((Object)entity), ReviewVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<ReviewVO> queryDetail(Long id) {
        ReviewEntity entity = (ReviewEntity)((Object)this.service.selectById(id));
        ReviewVO vo = (ReviewVO)BeanMapper.map((Object)((Object)entity), ReviewVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<ReviewVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReviewVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<ReviewVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        ArrayList reviews = new ArrayList();
        page.getRecords().forEach(e -> {
            ReviewVO review = (ReviewVO)BeanMapper.map((Object)e, ReviewVO.class);
            review.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)review.getBillState()).getDescription());
            reviews.add(review);
        });
        HashMap beans = new HashMap();
        beans.put("records", reviews);
        ExcelExport.getInstance().export("review-export.xlsx", beans, response);
    }

    @PostMapping(value={"/handlePrintDetail"})
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody String detailJsonStr) {
        this.logger.info("\u8fdb\u5165\u62db\u6807\u6587\u4ef6\u8bc4\u5ba1\u6253\u5370\u8be6\u60c5\u5904\u7406\uff01");
        if (StringUtils.isBlank((String)detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject((String)detailJsonStr);
        if (null == data) {
            return CommonResponse.success(null);
        }
        this.logger.info("\u83b7\u5f97\u6253\u5370\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
        JSONObject detailJson = data.getJSONObject("detailJson");
        if (null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject mainData = detailJson.getJSONObject("Review");
        this.logger.info("\u83b7\u5f97\u62db\u6807\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)mainData));
        String content = "";
        String result = "";
        List reviewContentManageList = JSONObject.parseArray((String)mainData.getString("ReviewContentManage"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u7ecf\u8425\u8d1f\u8d23\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)reviewContentManageList));
        for (Object manage : reviewContentManageList) {
            content = manage.getString("manageReviewContent");
            result = manage.getString("manageReviewResult");
            if (!StringUtils.isNotBlank((String)content)) continue;
            switch (content) {
                case "\u6807\u4e66\u6761\u6b3e\u662f\u5426\u5408\u7406\u3001\u6e05\u695a\u660e\u4e86\uff1f": {
                    mainData.put("manageReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u6295\u6807\u4e66\u5185\u5bb9\u662f\u5426\u6ee1\u8db3\u62db\u6807\u6587\u4ef6\u8981\u6c42\uff1f": {
                    mainData.put("manageReviewContentTwo", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u6295\u6807\u4e66\u6761\u6b3e\u662f\u5426\u4e0e\u62db\u6807\u6587\u4ef6\u53ca\u5408\u540c\u6cd5\u7b49\u76f8\u5173\u6cd5\u5f8b\u6cd5\u89c4\u53ca\u6807\u51c6\u8981\u6c42\u76f8\u543b\u5408\uff1f": {
                    mainData.put("manageReviewContentThree", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u6295\u6807\uff1f": {
                    mainData.put("manageReviewContentFour", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                }
            }
        }
        List reviewContentTechnologyList = JSONObject.parseArray((String)mainData.getString("ReviewContentTechnology"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u6280\u672f\u8d1f\u8d23\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)reviewContentTechnologyList));
        for (Object technology : reviewContentTechnologyList) {
            content = technology.getString("technologyReviewContent");
            result = technology.getString("technologyReviewResult");
            if (!StringUtils.isNotBlank((String)content)) continue;
            switch (content) {
                case "\u6807\u4e66\u4e2d\u7684\u6280\u672f\u6807\u51c6\u8981\u6c42\u662f\u5426\u80fd\u591f\u6ee1\u8db3\uff1f": {
                    mainData.put("technologyReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u4fdd\u969c\u8d28\u91cf\u3001\u5b89\u5168\u3001\u8fdb\u5ea6\u65b9\u9762\u7684\u6280\u672f\u63aa\u65bd\u662f\u5426\u80fd\u591f\u6ee1\u8db3\uff1f": {
                    mainData.put("technologyReviewContentTwo", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u5177\u5907\u6ee1\u8db3\u5de5\u7a0b\u8d28\u91cf\u3001\u5de5\u671f\u3001\u8fdb\u5ea6\u7b49\u8981\u6c42\u7684\u8d44\u6e90\uff1f": {
                    mainData.put("technologyReviewContentThree", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u6807\u4e66\u4e2d\u5bf9\u5b89\u5168\u3001\u73af\u5883\u65b9\u9762\u7684\u6761\u6b3e\u662f\u5426\u80fd\u591f\u6ee1\u8db3\uff1f": {
                    mainData.put("technologyReviewContentFour", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u6295\u6807\uff1f": {
                    mainData.put("technologyReviewContentFive", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                }
            }
        }
        List ReviewContentBudgetList = JSONObject.parseArray((String)mainData.getString("ReviewContentBudget"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u9884\u7b97\u8d1f\u8d23\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)ReviewContentBudgetList));
        for (JSONObject budget : ReviewContentBudgetList) {
            content = budget.getString("budgetReviewContent");
            result = budget.getString("budgetReviewResult");
            if (!StringUtils.isNotBlank((String)content)) continue;
            switch (content) {
                case "\u7f16\u5236\u6295\u6807\u9884\u7b97/\u51b3\u7b97\u7b49\u8ba1\u4ef7\u4f9d\u636e\u662f\u5426\u5408\u7406\u3001\u6e05\u695a\u660e\u4e86\uff1f": {
                    mainData.put("budgetReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u6295\u6807\u62a5\u4ef7\u662f\u5426\u80fd\u591f\u63a5\u53d7\uff1f": {
                    mainData.put("budgetReviewContentTwo", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u6295\u6807\u62a5\u4ef7\u8303\u56f4\u662f\u5426\u6e05\u695a\uff1f": {
                    mainData.put("budgetReviewContentThree", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u6295\u6807\uff1f": {
                    mainData.put("budgetReviewContentFour", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                }
            }
        }
        List ReviewContentFinanceList = JSONObject.parseArray((String)mainData.getString("ReviewContentFinance"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u8d22\u52a1\u8d1f\u8d23\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)ReviewContentFinanceList));
        for (JSONObject finance : ReviewContentFinanceList) {
            content = finance.getString("financeReviewContent");
            result = finance.getString("financeReviewResult");
            if (!StringUtils.isNotBlank((String)content)) continue;
            switch (content) {
                case "\u516c\u53f8\u662f\u5426\u5177\u5907\u6295\u6807\u4fdd\u51fd/\u4fdd\u8bc1\u91d1\u652f\u4ed8\u7684\u80fd\u529b\uff1f": {
                    mainData.put("financeReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u80fd\u591f\u63a5\u53d7\u6b3e\u9879\u652f\u4ed8\u6216\u57ab\u6b3e\u6761\u4ef6\uff1f": {
                    mainData.put("financeReviewContentTwo", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u5177\u5907\u5de5\u7a0b\u6b3e\u652f\u4ed8\u65b9\u9762\u7684\u80fd\u529b\uff1f": {
                    mainData.put("financeReviewContentThree", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u6295\u6807\uff1f": {
                    mainData.put("financeReviewContentFour", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                }
            }
        }
        List ReviewContentDirectList = JSONObject.parseArray((String)mainData.getString("ReviewContentDirect"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u76f4\u7ba1\u90e8 \uff08\u5206\u516c\u53f8\uff09\u8d1f\u8d23\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)ReviewContentDirectList));
        for (JSONObject direct : ReviewContentDirectList) {
            content = direct.getString("directReviewContent");
            result = direct.getString("directReviewResult");
            if (!StringUtils.isNotBlank((String)content)) continue;
            switch (content) {
                case "\u662f\u5426\u5177\u5907\u5de5\u7a0b\u65bd\u5de5\u7684\u80fd\u529b\uff1f": {
                    mainData.put("directReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u540c\u610f\u4e0a\u8ff0\u6761\u6b3e\u5185\u5bb9\uff1f": {
                    mainData.put("directReviewContentTwo", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u540c\u610f\u5176\u4ed6\u627f\u8bfa\u6761\u6b3e\uff1f": {
                    mainData.put("directReviewContentThree", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u6295\u6807\uff1f": {
                    mainData.put("directReviewContentFour", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                }
            }
        }
        List ReviewContentBusinessList = JSONObject.parseArray((String)mainData.getString("ReviewContentBusiness"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u7ecf\u8425\u90e8\u8d1f\u8d23\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)ReviewContentBusinessList));
        for (JSONObject business : ReviewContentBusinessList) {
            content = business.getString("businessReviewContent");
            result = business.getString("businessReviewResult");
            if (!StringUtils.isNotBlank((String)content)) continue;
            switch (content) {
                case "\u662f\u5426\u540c\u610f\u4e0a\u8ff0\u6761\u6b3e\u5185\u5bb9\uff1f": {
                    mainData.put("businessReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u540c\u610f\u5176\u4ed6\u627f\u8bfa\u6761\u6b3e\uff1f": {
                    mainData.put("businessReviewContentTwo", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                    break;
                }
                case "\u662f\u5426\u6295\u6807\uff1f": {
                    mainData.put("businessReviewContentThree", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
                }
            }
        }
        List ReviewContentDeputyList = JSONObject.parseArray((String)mainData.getString("ReviewContentDeputy"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u7ecf\u8425\u526f\u603b\u7ecf\u7406\u5ba1\u6838\u610f\u89c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)ReviewContentDeputyList));
        for (JSONObject deputy : ReviewContentDeputyList) {
            content = deputy.getString("deputyReviewContent");
            result = deputy.getString("deputyReviewResult");
            if (!StringUtils.isNotBlank((String)content) || !content.equals("\u662f\u5426\u6295\u6807\uff1f")) continue;
            mainData.put("deputyReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
        }
        List ReviewContentGmList = JSONObject.parseArray((String)mainData.getString("ReviewContentGm"), JSONObject.class);
        this.logger.info("\u83b7\u5f97\u603b\u7ecf\u7406\u5ba1\u6279\u610f\u89c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)ReviewContentGmList));
        for (JSONObject gm : ReviewContentGmList) {
            content = gm.getString("gmReviewContent");
            result = gm.getString("gmReviewResult");
            if (!StringUtils.isNotBlank((String)content) || !content.equals("\u662f\u5426\u6295\u6807\uff1f")) continue;
            mainData.put("gmReviewContentOne", (Object)(StringUtils.isNotBlank((String)result) ? ("0".equals(result) ? "\u5426" : "\u662f") : ""));
        }
        this.logger.info("\u5185\u5bb9\u8d4b\u503c\u540e\u7684mainData\uff1a{}", (Object)JSONObject.toJSONString((Object)mainData));
        detailJson.put("Review", (Object)mainData);
        this.logger.info("detailJson\uff1a{}", (Object)JSONObject.toJSONString((Object)detailJson));
        return CommonResponse.success((Object)detailJson);
    }
}

