package com.ejianc.business.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.mapper.ProcessMapper;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 投标流程实体
 *
 * @author baipengyan
 */
@Service("processService")
public class ProcessServiceImpl extends BaseServiceImpl<ProcessMapper, ProcessEntity> implements IProcessService {

	private static final String BUSINESS = "商机登记";
	private static final String PROJECT = "投标立项";
	private static final String REGIS_DATA = "报名资料";
	private static final String PREQUALIFICATION = "资格预审";
	private static final String TENDER = "标书购买";
	private static final String RECORD = "工程投标备案表";
	private static final String CALC = "标前测算";
	private static final String PAY = "保证金缴纳";
	private static final String REVIEW = "投标文件评审";
	private static final String OPEN = "开标记录";
	private static final String WIN = "中标登记";
	private static final String OTHER_FILE = "其他附件";

	/**
	 * 查询投标流程列表
	 *
	 * @param projectId 项目id
	 *
	 * @return 投标流程列表
	 */
	@Override
	public LinkedHashMap<String, List<ProcessEntity>> queryProcess(Long projectId) {
		LinkedHashMap<String, List<ProcessEntity>> linkedHashMap = new LinkedHashMap<>();

		LambdaQueryWrapper<ProcessEntity> l = new LambdaQueryWrapper<>();
		l.eq(ProcessEntity::getProjectId, projectId);
		l.orderByAsc(ProcessEntity::getCreateTime);
		List<ProcessEntity> list = super.list(l);
		if (CollectionUtils.isEmpty(list)) {
			return linkedHashMap;
		}
		Map<String, List<ProcessEntity>> listMap = list.stream().collect(Collectors.groupingBy(ProcessEntity::getBillName));
		if (listMap.containsKey(BUSINESS)) {
			linkedHashMap.put(BUSINESS, listMap.get(BUSINESS));
		}
		if (listMap.containsKey(PROJECT)) {
			linkedHashMap.put(PROJECT, listMap.get(PROJECT));
		}
		if (listMap.containsKey(REGIS_DATA)) {
			linkedHashMap.put(REGIS_DATA, listMap.get(REGIS_DATA));
		}
		if (listMap.containsKey(PREQUALIFICATION)) {
			linkedHashMap.put(PREQUALIFICATION, listMap.get(PREQUALIFICATION));
		}
		if (listMap.containsKey(TENDER)) {
			linkedHashMap.put(TENDER, listMap.get(TENDER));
		}
		if (listMap.containsKey(RECORD)) {
			linkedHashMap.put(RECORD, listMap.get(RECORD));
		}
		if (listMap.containsKey(CALC)) {
			linkedHashMap.put(CALC, listMap.get(CALC));
		}
		if (listMap.containsKey(PAY)) {
			linkedHashMap.put(PAY, listMap.get(PAY));
		}
		if (listMap.containsKey(REVIEW)) {
			linkedHashMap.put(REVIEW, listMap.get(REVIEW));
		}
		if (listMap.containsKey(OPEN)) {
			linkedHashMap.put(OPEN, listMap.get(OPEN));
		}
		if (listMap.containsKey(WIN)) {
			linkedHashMap.put(WIN, listMap.get(WIN));
		}
		if (listMap.containsKey(OTHER_FILE)) {
			linkedHashMap.put(OTHER_FILE, listMap.get(OTHER_FILE));
		}
		return linkedHashMap;
	}
}
