package com.ejianc.business.record.service;

import com.ejianc.business.record.bean.RecordEntity;
import com.ejianc.business.record.vo.RecordVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 工程投标备案实体
 *
 * @author generator
 */
public interface IRecordService extends IBaseService<RecordEntity> {

	/**
	 * 根据投标立项项目id查询工程投标备案记录
	 *
	 * @param projectId 投标立项项目id
	 */
	RecordVO queryDetailByProjectId(Long projectId);

	/**
	 * 只能有一个未生效的单据
	 *
	 * @param projectId 项目id
	 */
	void checkOnlyOne(Long projectId);
}
