package com.ejianc.business.review.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.review.bean.ReviewEntity;
import com.ejianc.business.review.mapper.ReviewMapper;
import com.ejianc.business.review.service.IReviewService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 投标文件评审实体
 *
 * @author generator
 */
@Service("reviewService")
public class ReviewServiceImpl extends BaseServiceImpl<ReviewMapper, ReviewEntity> implements IReviewService {

	/**
	 * 只能有一个未生效的单据
	 *
	 * @param projectId 项目id
	 */
	@Override
	public void checkOnlyOne(Long projectId) {
		QueryWrapper<ReviewEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		List<ReviewEntity> entities = super.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entities)) {
			throw new BusinessException("当前项目已存在未生效的单据！");
		}
	}

}
