package com.ejianc.business.win.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.win.bean.WinEntity;
import com.ejianc.business.win.mapper.WinMapper;
import com.ejianc.business.win.service.IWinService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 中标登记实体
 *
 * @author generator
 */
@Service("winService")
public class WinServiceImpl extends BaseServiceImpl<WinMapper, WinEntity> implements IWinService {

	/**
	 * 只能有一个未生效的单据
	 *
	 * @param projectId 项目id
	 */
	@Override
	public void checkOnlyOne(Long projectId) {
		QueryWrapper<WinEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		List<WinEntity> entities = super.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entities)) {
			throw new BusinessException("当前项目已存在未生效的单据！");
		}
	}

}
