package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.enums.BidStatusEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.vo.ProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 投标立项
 *
 * @author generator
 */
@Controller
@RequestMapping("project")
public class ProjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "QTF_CODE";//此处需要根据实际修改

    @Autowired
    private IProjectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVO> saveOrUpdate(@RequestBody ProjectVO saveOrUpdateVO) {
        ProjectEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            //初始化引用状态
            entity.setRegistDataFlag(0); //是否存在报名资料 "1" 存在 “0” 不存在
            entity.setPrequalificationFlag(0);//是否存在资格预审  "1" 存在 “0” 不存在
            entity.setWinFlag(0);// 标书购买是否生效 0-未生效，1-已生效
            entity.setOpenFlag(0);// 工程投标备案是否生效 0-未生效，1-已生效
            entity.setReviewFlag(0);// 标签测算是否生效 0-未生效，1-已生效
            entity.setPayFlag(0);// 风险保证金是否生效 0-未生效，1-已生效
            entity.setCalcFlag(0);// 投标文件评审是否生效 0-未生效，1-已生效
            entity.setRecordFlag(0);// 开标记录是否生效 0-未生效，1-已生效
            entity.setTenderFlag(0);// 中标登记是否生效 0-未生效，1-已生效

            if (entity.getBusinessId() != null) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ArrayList<Integer> billState = new ArrayList<>();
                billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                queryWrapper.eq("business_id", entity.getBusinessId());
                queryWrapper.eq("dr", 0);
                queryWrapper.notIn("bill_state", billState);
                int countReg = service.count(queryWrapper);
                if (countReg > 0) {
                    throw new BusinessException("当前商机下 有未生效的单据!");
                }
            }
        }
        if ("2".equals(entity.getProjectInitType())) {
            //初始化投标状态
            entity.setBidStatus(BidStatusEnum.未中标.getTypeName());
        } else {
            entity.setBidStatus(BidStatusEnum.投标中.getTypeName());
        }
        service.saveOrUpdate(entity, false);
        ProjectVO vo = BeanMapper.map(entity, ProjectVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectVO> queryDetail(Long id) {
        ProjectEntity entity = service.selectById(id);
        ProjectVO vo = BeanMapper.map(entity, ProjectVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("bidUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(orgId);
        if (!childrenByParentId.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", childrenByParentId.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProjectEntity> page = service.queryPage(param, false);
        IPage<ProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("bidUnitName");
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(orgId);
        param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<ProjectVO> vos = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        list.forEach(e -> {
            ProjectVO vo = BeanMapper.map(e, ProjectVO.class);
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            vo.setCreateTimeStr(sdf.format(vo.getCreateTime()));
            vo.setBidOpenDateStr(sdf.format(vo.getBidOpenDate()));
            vo.setRegistrationDeadlineStr(sdf.format(vo.getRegistrationDeadline()));
            vos.add(vo);
        });
        beans.put("records", vos);
        ExcelExport.getInstance().export("Project-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //设置模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("constructionUnit");
        fuzzyFields.add("applyUserId");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidUnitName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(orgId);
        param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

//            if (condition.contains("bidUnitId")) {
//                CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(Long.valueOf(_con.getString("bidUnitId")).longValue());
//                if (!childrenByParentId.isSuccess()) {
//                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", childrenByParentId.getMsg());
//                    return CommonResponse.error("查询失败，获取组织信息失败！");
//                }
//                param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            }

            if (condition.contains("bidStatus")) {
                Integer bidStatus = Integer.valueOf(_con.getString("bidStatus"));
                param.getParams().put("bid_status", new Parameter(QueryParam.EQ, BidStatusEnum.getByCode(bidStatus).getTypeName()));
            }

            if (condition.contains("tenderFlag") && condition.contains("prequalificationFlag")) {
                String tenderFlag = _con.getString("tenderFlag");
                String prequalificationFlag = _con.getString("prequalificationFlag");

                //说明当前是标书购买 reviewMode
                param.getParams().put("", new Parameter(QueryParam.SQL, "tender_flag = " + tenderFlag + " and (prequalification_Flag = " + prequalificationFlag + " or review_mode = 1)"));
            } else if (condition.contains("tenderFlag")) {
                String tenderFlag = _con.getString("tenderFlag");
                param.getParams().put("tender_flag", new Parameter(QueryParam.EQ, Integer.valueOf(tenderFlag)));
            } else if (condition.contains("prequalificationFlag")) {
                String prequalificationFlag = _con.getString("prequalificationFlag");
                param.getParams().put("prequalification_flag", new Parameter(QueryParam.EQ, prequalificationFlag));
            }

            if (condition.contains("recordFlag")) {
                String recordFlag = _con.getString("recordFlag");
                param.getParams().put("record_flag", new Parameter(QueryParam.EQ, Integer.valueOf(recordFlag)));
            }

            // if (condition.contains("calcFlag")) {
            //     String calcFlag = _con.getString("calcFlag");
            //     param.getParams().put("calc_flag", new Parameter(QueryParam.EQ, Integer.valueOf(calcFlag)));
            // }

            if (condition.contains("payFlag")) {
                String payFlag = _con.getString("payFlag");
                param.getParams().put("pay_flag", new Parameter(QueryParam.EQ, Integer.valueOf(payFlag)));
            }

            if (condition.contains("reviewFlag")) {
                String reviewFlag = _con.getString("reviewFlag");
                param.getParams().put("review_flag", new Parameter(QueryParam.EQ, Integer.valueOf(reviewFlag)));
            }

            if (condition.contains("winFlag") && condition.contains("openFlag")) {
                String winFlag = _con.getString("winFlag");
                param.getParams().put("win_flag", new Parameter(QueryParam.EQ, Integer.valueOf(winFlag)));

                String openFlag = _con.getString("openFlag");
                param.getParams().put("", new Parameter(QueryParam.SQL, "((project_init_type = '0' and open_flag = " + Integer.valueOf(openFlag) + ") or project_init_type = '1')"));
            } else if (condition.contains("openFlag")) {
                String openFlag = _con.getString("openFlag");
                param.getParams().put("openFlag", new Parameter(QueryParam.EQ, Integer.valueOf(openFlag)));
            }

            if (condition.contains("registDataFlag")) {
                String registDataFlag = _con.getString("registDataFlag");
                param.getParams().put("regist_data_flag", new Parameter(QueryParam.EQ, registDataFlag));
            }

        }
        /**
         * 数据过滤
         */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));

        /** 设置排序*/
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<ProjectEntity> pageData = service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ProjectVO.class));
        logger.info("records----{}", JSONObject.toJSONString(page.get("records")));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询参照数据成功！", page);
    }
}
