package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetCostReportMapper;
import com.ejianc.business.budget.service.IBudgetCostReportService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.utils.DecimalUtils;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.business.budget.vo.BudgetCostReportVO;
import com.ejianc.business.budget.vo.comparator.BudgetCostReportDetailComparatoeVO;
import com.ejianc.business.budget.utils.ITreeNodeB;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

/**
 * 预算与成本报表
 * 
 * @author generator
 * 
 */
@Service("budgetCostReportService")
public class BudgetCostReportServiceImpl extends BaseServiceImpl<BudgetCostReportMapper, BudgetCostReportDetailVO> implements IBudgetCostReportService {

    @Autowired
    private IBudgetProjectService budgetService;

    @Override
    public CommonResponse<BudgetCostReportVO> queryReport(Long projectId) {
        LambdaQueryWrapper<BudgetProjectEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(BudgetProjectEntity::getProjectId, projectId);
        lambda.and(wrapper -> wrapper.eq(BudgetProjectEntity::getBillState, 1).or().eq(BudgetProjectEntity::getBillState, 3));
        BudgetProjectEntity budgetEntity = budgetService.getOne(lambda);

        BudgetCostReportVO vo = new BudgetCostReportVO();
        vo.setProjectId(projectId);
        List<BudgetCostReportDetailVO> detailList = baseMapper.getBudgetCostReport(projectId);
        //实现排序
        Collections.sort(detailList, new BudgetCostReportDetailComparatoeVO());
        // 汇总成本金额与预算金额
//        BigDecimal budgetMny = null;// 预算金额
        BigDecimal costMny = null;// 成本金额
        // 考虑有可能挂到父级成本科目
        if(CollectionUtils.isNotEmpty(detailList)){
            for(BudgetCostReportDetailVO detail : detailList){
                if(detail.getLeafFlag().equals(1)){
//                    budgetMny = DecimalUtils.add(budgetMny, detail.getBudgetMny());
                    costMny = DecimalUtils.add(costMny, detail.getCostMny());
                    detail.setBudgetCostMny(DecimalUtils.subtractNull(detail.getBudgetMny(), detail.getCostMny()));// 预算-成本
                }
            }
            vo.setBudgetMny(budgetEntity != null ? budgetEntity.getBudgetMny() : null);
            vo.setCostMny(costMny);
            vo.setProjectName(detailList.get(0).getProjectName());
            // 构造树形
            List<BudgetCostReportDetailVO> treeList = TreeNodeBUtil.buildTree(detailList);
            for(BudgetCostReportDetailVO child : treeList){
                this.dealChildList(child);
            }
            vo.setDetailList(treeList);
        }
        return CommonResponse.success(vo);
    }

    /**
     * 递归汇总子级
     * @param vo
     */
    private void dealChildList(BudgetCostReportDetailVO vo){
        BigDecimal budgetMny = null;// 预算金额
        BigDecimal costMny = null;// 成本金额
        if(CollectionUtils.isNotEmpty(vo.getChildren())){
            List<BudgetCostReportDetailVO> list = BeanMapper.mapList(vo.getChildren(), BudgetCostReportDetailVO.class);
            for(BudgetCostReportDetailVO child : list){
                this.dealChildList(child);
                budgetMny = DecimalUtils.add(budgetMny, child.getBudgetMny());
                costMny = DecimalUtils.add(costMny, child.getCostMny());
            }
            vo.setBudgetMny(budgetMny);
            vo.setCostMny(costMny);
            vo.setBudgetCostMny(DecimalUtils.subtractNull(budgetMny, costMny));// 预算-成本
            vo.setChildren(BeanMapper.mapList(list, ITreeNodeB.class));
        }
    }
}
