package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 项目预算清单
 * 
 * @author generator
 * 
 */
@Service("budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity> implements IBudgetProjectDetailService{

    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Override
    public void deleteByBudgetId(Long id) {
        QueryWrapper<BudgetProjectDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("budget_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetProjectDetailVO> detailVoList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex,id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    }else{
                        indexMap.put(detailIndex,i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"项目名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setProjectFeature(datas.get(3));//项目特征
                    vo.setUnit(datas.get(4));
//                    if (StringUtils.isEmpty(datas.get(4))) {//清单名称为空
//                        vo.setUnit(null);
//                        warnType =  warnType+"单位为空,";
//                        flag = true;
//                        parentWarn = true;
//                    } else {
//                        vo.setUnit(datas.get(4));
//                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType+"工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

//                    if (StringUtils.isEmpty(datas.get(6))) {
//                        vo.setPrice(null);
//                        warnType = warnType+"综合单价为空,";
//                        flag = true;
//                    } else {
//                        try {
//                            vo.setPrice(new BigDecimal(datas.get(6)));
//                        } catch (Exception e) {
//                            vo.setPrice(null);
//                            warnType = warnType+"综合单价只能为数字或小数,";
//                            flag = true;
//                        }
//                    }

                    if (StringUtils.isEmpty(datas.get(7))) {// 不是强制必输
                        vo.setLaborCost(null);
                    } else {
                        try {
                            vo.setLaborCost(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setLaborCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {// 不是强制必输
                        vo.setMaterialCost(null);
                    } else {
                        try {
                            vo.setMaterialCost(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setMaterialCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {// 不是强制必输
                        vo.setMechanicalCost(null);
                    } else {
                        try {
                            vo.setMechanicalCost(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setMechanicalCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {// 不是强制必输
                        vo.setOtherCost(null);
                    } else {
                        try {
                            vo.setOtherCost(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setOtherCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(11))) {
                        vo.setMny(null);
                        warnType = warnType+"合价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType+"合价只能为数字或小数,";
                            flag = true;
                        }
                    }



                    if (null == vo.getNum() || null == vo.getMny()) {
                        vo.setPrice(null);
                    } else {
                        if(vo.getNum().compareTo(BigDecimal.ZERO)==0){
                            vo.setPrice(null);
                        }else{
                            vo.setPrice(vo.getMny().divide(vo.getNum(),20 ,BigDecimal.ROUND_HALF_EVEN));
                        }
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for(BudgetProjectDetailVO tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList",allList.get(0));
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    //清单参照
    @Override
    public List<BudgetProjectDetailVO> detailRef(Long projectId) {
        // 根据项目获取主表主键
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, projectId);
        queryWrapper.and(wrapper -> wrapper.eq(BudgetProjectEntity::getBillState, 1).or().eq(BudgetProjectEntity::getBillState, 3));
        BudgetProjectEntity entity = budgetProjectService.getOne(queryWrapper);
        // 根据主表主键查询子表
        List<BudgetProjectDetailVO> detailList = new ArrayList<>();
        if(entity != null && entity.getId() != null){
            LambdaQueryWrapper<BudgetProjectDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(BudgetProjectDetailEntity::getBudgetId, entity.getId());
            wrapper.ne(BudgetProjectDetailEntity::getChangeType,5);//中止不显示
            wrapper.orderBy(true,true,BudgetProjectDetailEntity::getDetailIndex);
            List<BudgetProjectDetailEntity> entityList = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(entityList)) {
                for(BudgetProjectDetailEntity i : entityList){
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                }
            }
            detailList = BeanMapper.mapList(entityList, BudgetProjectDetailVO.class);
            //实现排序
            Collections.sort(detailList, new BudgetDetailComparatoeVo());
        }
        return TreeNodeBUtil.buildTree(detailList);
    }
}
