package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetPlanItemTemVO;
import com.ejianc.business.plan.vo.BudgetPlanVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工计划
 *
 * @author generator
 */
@Controller
@RequestMapping("budgetPlan")
public class BudgetPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROBUDGET_PLAN";//此处需要根据实际修改

    @Autowired
    private IBudgetPlanService service;


    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;


 /*   @RequestMapping(value = "/loadBudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetPlanVO> loadBudget(@RequestBody BudgetPlanVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetByProjectId(planVO.getProjectId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(planVO.getStartMonth(), planVO.getEndMonth());

        if (planVO.getId() != null) {
            CommonResponse<BudgetPlanVO> budgetPlanVOCommonResponse = this.queryDetail(planVO.getId());
            BudgetPlanVO plan = budgetPlanVOCommonResponse.getData();
            plan.setMonthColumn(months);
            plan.setStartMonth(planVO.getStartMonth());
            plan.setEndMonth(planVO.getEndMonth());
            return CommonResponse.success("查询项目预算计划数据成功！", plan);
        }
        planVO.setMonthColumn(months);
        planVO.setDetailList(BeanMapper.mapList(vo.getDetailList(), BudgetDetailTemVO.class));
        return CommonResponse.success("查询项目预算计划数据成功！", planVO);
    }
*/

    /***
     * @description: 新增 引入预算数据
     * @param planVO
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.BudgetPlanVO>
     * @author songlx
     * @date: 2021/9/7
     */
    @RequestMapping(value = "/loadBudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetTemVO> loadBudget(@RequestBody BudgetPlanVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetByProjectId(planVO.getProjectId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(planVO.getStartMonth(), planVO.getEndMonth());
        vo.setMonthColumn(months);

        return CommonResponse.success("查询项目预算成功！", vo);
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetPlanVO> saveOrUpdate(@RequestBody BudgetPlanVO saveorUpdateVO) {
        BudgetPlanEntity entity = BeanMapper.map(saveorUpdateVO, BudgetPlanEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<BudgetDetailTemVO> detailList = saveorUpdateVO.getDetailList();
        List<BudgetPlanItemEntity> itemList = new ArrayList<>();
        for (BudgetDetailTemVO v : detailList) {
            if (CollectionUtils.isNotEmpty(v.getItemList())) {
                List<BudgetPlanItemEntity> budgetPlanItemEntities = BeanMapper.mapList(v.getItemList(), BudgetPlanItemEntity.class);
                itemList.addAll(budgetPlanItemEntities);
            }
        }
        service.saveOrUpdate(entity, false);
        if (CollectionUtils.isNotEmpty(itemList)) {
            List<Long> detailIds = itemList.stream().map(BudgetPlanItemEntity::getDetailId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemEntity> oldItems = budgetPlanItemService.queryList(param);
            if (CollectionUtils.isNotEmpty(oldItems)) {
                Map<String, BudgetPlanItemEntity> oldMap = oldItems.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), (k) -> k));
                itemList.forEach(t -> {
                            Long detailId = t.getDetailId();
                            t.setPlanId(entity.getId());
                            BudgetPlanItemEntity oldVO = oldMap.get(detailId + t.getYyearMonth());
                            if (null != oldVO) {
                                t.setId(oldVO.getId());
                                t.setVersion(oldVO.getVersion());
                            }

                        }
                );
            } else {
                itemList.forEach(t -> t.setPlanId(entity.getId()));
            }
            budgetPlanItemService.saveOrUpdateBatch(itemList);
        }

        return this.queryDetail(entity.getId());
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetPlanVO> queryDetail(Long id) {
        BudgetPlanEntity entity = service.selectById(id);
        BudgetPlanVO planVO = BeanMapper.map(entity, BudgetPlanVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetById(entity.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(entity.getStartMonth(), entity.getEndMonth());
        planVO.setMonthColumn(months);
        List<BudgetDetailTemVO> detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<Long> detailIds = detailList.stream().map(BudgetDetailTemVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);

            List<BudgetPlanItemTemVO> itemTemVOS = BeanMapper.mapList(planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList(listMap.get(t.getId())));
            planVO.setDetailList(detailList);
        }
        return CommonResponse.success("查询详情数据成功！", planVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetPlanVO> vos) {
        service.removeByIds(vos.stream().map(BudgetPlanVO::getId).collect(Collectors.toList()), true);
        List<Long> planIds = vos.stream().map(BudgetPlanVO::getId).collect(Collectors.toList());
        QueryWrapper<BudgetPlanItemEntity> rapper = new QueryWrapper<>();
        rapper.in("plan_id", planIds);
        budgetPlanItemService.remove(rapper);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BudgetPlanEntity> page = service.queryPage(param, false);
        IPage<BudgetPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanVO>> refBudgetPlanData(@RequestParam Integer
                                                                         pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetPlanEntity> page = service.queryPage(param, false);
        IPage<BudgetPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
