package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.service.IBudgetPlanService;

import java.util.Arrays;
import java.util.List;

/**
 * 施工计划
 *
 * @author generator
 */
@Service("budgetPlanService")
public class BudgetPlanServiceImpl extends BaseServiceImpl<BudgetPlanMapper, BudgetPlanEntity> implements IBudgetPlanService {

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Override
    public CommonResponse<BudgetTemVO> getBudgetByProjectId(Long projectId) {
        QueryWrapper<BudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetEntity> list = budgetService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到生效的项目预算！");
        }
        BudgetEntity budgetEntity = list.get(0);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        budgetEntity.setDetailList(detailList);
        return CommonResponse.success(BeanMapper.map(budgetEntity, BudgetTemVO.class));
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetById(Long budgetId) {
        BudgetEntity budgetEntity = budgetService.getById(budgetId);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        budgetEntity.setDetailList(detailList);
        return CommonResponse.success(BeanMapper.map(budgetEntity, BudgetTemVO.class));
    }
}
