package com.ejianc.business.plan.bean.api;

import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/BudgetPlan/")
public class BudgetPlanApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IBudgetPlanService budgetPlanService;

    @RequestMapping(value = "recal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecalculateVO> recal(@RequestBody RecalculateVO vo) {
        return budgetPlanService.recalculate(vo, 2);
    }


}
