package com.ejianc.business.budget.service.impl;

import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetMapper;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 预算管理
 *
 * @author generator
 *
 */
@Service("budgetService")
public class BudgetServiceImpl extends BaseServiceImpl<BudgetMapper, BudgetEntity> implements IBudgetService{

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    private static final String BILL_CODE = "PROBUDGET_BUDGET";

    @Override
    public BudgetVO insertOrUpdate(BudgetVO budgetVO) {
        if(StringUtils.isEmpty(budgetVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                budgetVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BudgetEntity budgetEntity = BeanMapper.map(budgetVO, BudgetEntity.class);
        budgetEntity.setBaseIncomebudgetMny(budgetEntity.getIncomebudgetMny());
        budgetEntity.setBeforeIncomebudgetMny(budgetEntity.getIncomebudgetMny());
        budgetEntity.setChangingIncomebudgetMny(budgetEntity.getIncomebudgetMny());

        budgetEntity.setBaseCostbudgetMny(budgetEntity.getCostbudgetMny());
        budgetEntity.setBeforeCostbudgetMny(budgetEntity.getCostbudgetMny());
        budgetEntity.setChangingCostbudgetMny(budgetEntity.getCostbudgetMny());

        budgetEntity.setBaseLaborMny(budgetEntity.getLaborMny());
        budgetEntity.setBeforeLaborMny(budgetEntity.getLaborMny());
        budgetEntity.setChangingLaborMny(budgetEntity.getLaborMny());

        budgetEntity.setBaseMaterialMny(budgetEntity.getMaterialMny());
        budgetEntity.setBeforeMaterialMny(budgetEntity.getMaterialMny());
        budgetEntity.setChangingMaterialMny(budgetEntity.getMaterialMny());

        budgetEntity.setBaseManageMny(budgetEntity.getManageMny());
        budgetEntity.setBeforeManageMny(budgetEntity.getManageMny());
        budgetEntity.setChangingManageMny(budgetEntity.getManageMny());

        budgetEntity.setBaseIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());
        budgetEntity.setBeforeIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());
        budgetEntity.setChangingIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());

        super.saveOrUpdate(budgetEntity, false);

        List<BudgetDetailEntity> detailEntityList = budgetEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(detailEntityList)){
            Map<String,Long> idMap=new HashMap<>();
            for(BudgetDetailEntity cdEntity : detailEntityList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(BudgetDetailEntity cdEntity : detailEntityList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            budgetDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return queryDetail(budgetEntity.getId(), true);
    }

    @Override
    public BudgetVO queryDetail(Long id, boolean detailHasChildren) {
        BudgetEntity budgetEntity = super.selectById(id);
        BudgetVO budgetVO =  BeanMapper.map(budgetEntity, BudgetVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("budgetId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<BudgetDetailEntity> detailEntityListDb = budgetDetailService.queryList(queryParam, false);
        List<BudgetDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(BudgetDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<BudgetDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, BudgetDetailVO.class);
            if(detailHasChildren){
                budgetVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                budgetVO.setDetailList(resultMapList);
            }
        }
        return budgetVO;
    }
}
