package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.material.api.IMaterialInstoreApi;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工计划
 *
 * @author generator
 */
@Service("budgetPlanService")
public class BudgetPlanServiceImpl extends BaseServiceImpl<BudgetPlanMapper, BudgetPlanEntity> implements IBudgetPlanService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static BigDecimal ONE_WAN = new BigDecimal("10000");

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @Autowired
    IMaterialInstoreApi materialInstoreApi;

    @Override
    public CommonResponse<BudgetTemVO> getBudgetVOByProjectId(Long projectId) {
        QueryWrapper<BudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetEntity> list = budgetService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到生效的项目预算！");
        }
        BudgetEntity budgetEntity = list.get(0);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        wrapper.orderByAsc("tree_index");
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = BeanMapper.map(budgetEntity, BudgetTemVO.class);
        List<BudgetDetailTemVO> resultMapList = BeanMapper.mapList(detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success(vo);
    }

    @Override
    public CommonResponse<BudgetEntity> getBudgetByProjectId(Long projectId) {
        QueryWrapper<BudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetEntity> list = budgetService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到生效的项目预算！");
        }
        BudgetEntity budgetEntity = list.get(0);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        wrapper.orderByAsc("tree_index");
        //wrapper.in("level_no", Arrays.asList(1, 2, 3));
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        budgetEntity.setDetailList(detailList);
        return CommonResponse.success(budgetEntity);
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetById(Long budgetId) {
        BudgetEntity budgetEntity = budgetService.getById(budgetId);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        wrapper.orderByAsc("tree_index");
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = BeanMapper.map(budgetEntity, BudgetTemVO.class);
        List<BudgetDetailTemVO> resultMapList = BeanMapper.mapList(detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success(vo);
    }

    /**
     * @param cal        计算vo
     * @param updateFlag 更新标志
     * @description: 计算vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.BudgetTemVO>
     * @author songlx
     * @date: 2021/9/10
     */
    @Override
    public CommonResponse<RecalculateVO> recalculate(RecalculateVO cal, int updateFlag) {
        //获取按最新的预算
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = budgetService.selectById(cal.getBudgetId());
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = budgetByProjectId.getData();
        }

        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (budgetEntity == null || CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error("未查询到项目预算下的明细!");
        }
        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));

        if (level4Map == null || level4Map.isEmpty()) {
            return CommonResponse.error("未查询到项目预算下材料明细(四级)!");
        }

        // 获取计划
        BudgetPlanEntity budgetPlanEntity = null;
        QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq("budget_id", cal.getBudgetId());
        } else {
            queryWrapper.eq("project_id", cal.getProjectId());
        }
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetPlanEntity> list = this.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到项目的施工计划!");
        }
        budgetPlanEntity = list.get(0);

        /**
         一.项目预算变更   到货量为准
         1.更新累计值;
         2.计算当月;
         二.物资入库回写
         1.计算当月;

         */
        // 需要更新历史比例,此处为预算变更类回写 根据完成量 和 变化后的成本量 更新完成比例
        if (updateFlag == 1) {
            List<Long> level3Ids = new ArrayList<>(level3Map.keySet());
            QueryParam param = new QueryParam();
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, level3Ids));
            //大约当前月 2021-09-11
            String currentDay = DateUtil.getCurrentDay(null);
            String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
            //大约当前月 25
            String _endMonthDate = curMonth + "-" + budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "30";
            if (_endMonthDate.compareTo(currentDay) >= 0) {
                param.getParams().put("yyear_month", new Parameter(QueryParam.LT, curMonth));
            } else {
                param.getParams().put("yyear_month", new Parameter(QueryParam.LE, curMonth));
            }
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);
            planItemEntities.forEach(t -> {
                t.setFinishRatio(ComputeUtil.bigDecimalPercent(t.getFinishNum(), level3Map.get(t.getDetailId()), 8));
            });
            budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
        }
        if (updateFlag == 2) {

            //每种材料的预算量
            Map<Long, BigDecimal> level4BudgetNumMap = new HashMap<>();
            level4Map.forEach((k, v) -> level4BudgetNumMap.put(k, v.stream().filter(s -> s.getMaterialPlanNum() != null).map(BudgetDetailEntity::getMaterialPlanNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

            Map<String, Object> queryParam = new HashMap<>();
            queryParam.put("projectId", cal.getProjectId());
            queryParam.put("materialIds", new ArrayList<>(level4Map.keySet()));
            //大约当前月 2021-09-11
            String currentDay = DateUtil.getCurrentDay(null);
            String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
            String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "30";
            //大约当前月 25
            String _endMonthDate = curMonth + "-" + endDay;
            if (_endMonthDate.compareTo(currentDay) >= 0) {
                queryParam.put("endMonth", _endMonthDate);
            } else {
                //如果截止日期今天之前,那说明当前月是在下月
                queryParam.put("endMonth", DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH) + endDay);
            }
            CommonResponse<List<InstoreMaterialVO>> listCommonResponse = materialInstoreApi.instoreNumCount(queryParam);
            if (!listCommonResponse.isSuccess()) {
                logger.error(listCommonResponse.getMsg());
                return CommonResponse.error(listCommonResponse.getMsg());
            }
            if (CollectionUtils.isEmpty(listCommonResponse.getData())) {
                return CommonResponse.success("未查询到物资入库数量信息!");
            }
            Map<Long, BigDecimal> level4InstoreMap = listCommonResponse.getData().stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getInstoreNumber()));
            //计算材料的到货量/预算量,如果到货量大于预算量,则按照1计算
            Map<Long, BigDecimal> instoreBudgetMap = new HashMap<>();
            level4BudgetNumMap.forEach((k, v) -> instoreBudgetMap.put(k, ComputeUtil.isGreaterOrEqual(level4InstoreMap.get(k), v) ? BigDecimal.ONE : ComputeUtil.safeDiv(level4InstoreMap.get(k), v)));

            //key 是detailId 可以获取每种工艺下的所有材料 材料使用率  材料权重
            Map<Long, List<BudgetDetailEntity>> level3ChildMap = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getParentId));

            QueryParam p = new QueryParam();
            p.getParams().put("plan_id", new Parameter(QueryParam.EQ, budgetPlanEntity.getId()));
            //大约当前月 2021-09-11
            String currentDay1 = DateUtil.getCurrentDay(null);
            String curMonth1 = DateUtil.getCurrentDay(DateUtil.MONTH);
            String endDay1 = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "30";
            //大约当前月 25
            String _endMonthDate1 = curMonth1 + "-" + endDay;
            QueryWrapper pw = changeToQueryWrapper(p);
            if (_endMonthDate1.compareTo(currentDay1) >= 0) {
                String start = DateUtil.format(DateUtil.minusMonths(1), DateUtil.MONTH) + "-" + endDay1;
                pw.apply("(yyear_month >= '" + start + "' and yyear_month < '" + _endMonthDate1 + "')");
            } else {
                //如果截止日期今天之前,那说明当前月是在下月
                String end = DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH) + "-" + endDay1;
                pw.apply("(yyear_month >= '" + _endMonthDate1 + "' and yyear_month < '" + end + "')");
            }
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.list(pw);

            planItemEntities.forEach(t -> {
                Long detailId = t.getDetailId();
                List<BudgetDetailEntity> budgetDetailEntities = level3ChildMap.get(detailId);
                if (CollectionUtils.isNotEmpty(budgetDetailEntities)) {
                    BigDecimal _subFinishRatio = BigDecimal.ZERO;
                    for (BudgetDetailEntity k : budgetDetailEntities) {
                        Long materialId = k.getMaterialId();
                        BigDecimal instoreNumBudgetNum = instoreBudgetMap.get(materialId);
                        BigDecimal b1 = ComputeUtil.safeMultiply(instoreNumBudgetNum, k.getMaterialUsedScale(), k.getMaterialWeightScale());
                        _subFinishRatio = ComputeUtil.safeAdd(_subFinishRatio, ComputeUtil.safeDiv(b1, ONE_WAN));
                    }
                    //完成比例E1=（每种材料种类累计到货量/预算量*预算中的材料使用率字段）*材料产值权重占比
                    //①如果累计到货量/预算量>=100%，则按照1计算
                    //②材料使用率取数：如果材料需求申请标识【已完成】状态，材料使用率按照1计算
                    t.setFinishRatio(_subFinishRatio);
                    //完成工程量 = 完成比例 * 成本工程量
                    t.setFinishNum(ComputeUtil.safeMultiply(_subFinishRatio, level3Map.get(detailId)));
                }
            });
            budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
        }
        return CommonResponse.success("重新计算项目施工计划信息成功!");
    }
}
