/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetChangeDetailEntity;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.mapper.BudgetChangeMapper;
import com.ejianc.business.budget.service.IBudgetChangeDetailService;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetChangeDetailVO;
import com.ejianc.business.budget.vo.BudgetChangeVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetChangeService")
public class BudgetChangeServiceImpl
extends BaseServiceImpl<BudgetChangeMapper, BudgetChangeEntity>
implements IBudgetChangeService {
    private static final String BILL_CODE = "PROBUDGET_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IBudgetChangeDetailService budgetChangeDetailService;

    @Override
    public BudgetChangeVO insertOrUpdate(BudgetChangeVO changeVO) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        Object entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(BudgetChangeEntity::getBudgetId, (Object)changeVO.getBudgetId());
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.ne(BudgetChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(BudgetChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u9884\u7b97\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)changeVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                changeVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BudgetChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BudgetChangeEntity::getBudgetId, (Object)changeVO.getBudgetId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)changeVO.getBudgetId()));
            entitiesc = this.budgetService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BudgetChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.ne(BudgetChangeEntity::getBudgetId, (Object)changeVO.getBudgetId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)changeVO.getBudgetId()));
            entitiesc = this.budgetService.queryList(queryParam, false);
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        BudgetChangeEntity BudgetChangeEntity2 = (BudgetChangeEntity)((Object)BeanMapper.map((Object)changeVO, BudgetChangeEntity.class));
        List<BudgetChangeDetailEntity> beforeDetails = BudgetChangeEntity2.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == BudgetChangeEntity2.getId()) {
            for (BudgetChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)BudgetChangeEntity2, false);
        List<BudgetChangeDetailEntity> changeDetailEntities = BudgetChangeEntity2.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetChangeDetailEntity cdEntity : changeDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetChangeDetailEntity cdEntity : changeDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.budgetChangeDetailService.saveOrUpdateBatch(changeDetailEntities, changeDetailEntities.size(), false);
        }
        this.saveWriteContract(BudgetChangeEntity2);
        return this.queryDetail(BudgetChangeEntity2.getId());
    }

    private void saveWriteContract(BudgetChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(BudgetEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(BudgetEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(BudgetEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(BudgetEntity::getChangingCostbudgetMny, (Object)changeEntity.getCostbudgetMny());
        updateWrapper.set(BudgetEntity::getChangingIncomebudgetAdjustMny, (Object)changeEntity.getIncomebudgetAdjustMny());
        updateWrapper.set(BudgetEntity::getChangingIncomebudgetMny, (Object)changeEntity.getIncomebudgetMny());
        updateWrapper.set(BudgetEntity::getChangingLaborMny, (Object)changeEntity.getLaborMny());
        updateWrapper.set(BudgetEntity::getChangingManageMny, (Object)changeEntity.getManageMny());
        updateWrapper.set(BudgetEntity::getChangingManageRate, (Object)changeEntity.getManageMny());
        updateWrapper.set(BudgetEntity::getChangingMaterialMny, (Object)changeEntity.getMaterialMny());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getBudgetId());
        this.budgetService.update(this.budgetService.selectById(changeEntity.getBudgetId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public BudgetChangeVO addConvertByConId(Long budgetId) {
        BudgetVO budgetVO = this.budgetService.queryDetail(budgetId, false);
        BudgetChangeVO changeVO = (BudgetChangeVO)BeanMapper.map((Object)budgetVO, BudgetChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeCostbudgetMny(budgetVO.getCostbudgetMny());
        changeVO.setBeforeIncomebudgetAdjustMny(budgetVO.getIncomebudgetAdjustMny());
        changeVO.setBeforeIncomebudgetMny(budgetVO.getIncomebudgetMny());
        changeVO.setBeforeLaborMny(budgetVO.getLaborMny());
        changeVO.setBeforeManageMny(budgetVO.getManageMny());
        changeVO.setBeforeManageRate(budgetVO.getManageRate());
        changeVO.setBeforeMaterialMny(budgetVO.getMaterialMny());
        changeVO.setBudgetId(changeVO.getId());
        changeVO.setChangeVersion(Integer.valueOf(budgetVO.getChangeVersion() == null ? 1 : budgetVO.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcBid(changeDetailVO.getId());
                changeDetailVO.setBeforeBudgetMoney(changeDetailVO.getBudgetMoney());
                changeDetailVO.setBeforeBudgetNum(changeDetailVO.getBudgetNum());
                changeDetailVO.setBeforeBudgetPrice(changeDetailVO.getBudgetPrice());
                changeDetailVO.setBeforeBudgetUnit(changeDetailVO.getBudgetUnit());
                changeDetailVO.setBeforeCostMoney(changeDetailVO.getCostMoney());
                changeDetailVO.setBeforeCostNum(changeDetailVO.getCostNum());
                changeDetailVO.setBeforeCostPrice(changeDetailVO.getCostPrice());
                changeDetailVO.setBeforeMaterialMoney(changeDetailVO.getMaterialMoney());
                changeDetailVO.setBeforeMaterialPlanNum(changeDetailVO.getMaterialPlanNum());
                changeDetailVO.setBeforeMaterialPrice(changeDetailVO.getMaterialPrice());
                changeDetailVO.setBeforeMaterialUnit(changeDetailVO.getMaterialUnit());
                changeDetailVO.setBeforeMaterialUsedNum(changeDetailVO.getMaterialUsedNum());
                changeDetailVO.setBeforeMaterialUsedScale(changeDetailVO.getMaterialUsedScale());
                changeDetailVO.setBeforeMaterialWeightScale(changeDetailVO.getMaterialWeightScale());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setChangeType(null);
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        return changeVO;
    }

    @Override
    public BudgetChangeVO queryDetail(Long id) {
        BudgetChangeEntity changeEntity = (BudgetChangeEntity)((Object)super.selectById((Serializable)id));
        BudgetChangeVO changeVO = (BudgetChangeVO)BeanMapper.map((Object)((Object)changeEntity), BudgetChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("changeId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.budgetChangeDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (BudgetChangeDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, BudgetChangeDetailVO.class);
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<BudgetChangeVO> vos) {
        BudgetChangeVO changeVo = vos.get(0);
        BudgetChangeEntity entity = (BudgetChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        BudgetEntity pcentity = (BudgetEntity)((Object)this.budgetService.selectById(entity.getBudgetId()));
        pcentity.setId(entity.getBudgetId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        pcentity.setChangingCostbudgetMny(BigDecimal.ZERO);
        pcentity.setChangingIncomebudgetAdjustMny(BigDecimal.ZERO);
        pcentity.setChangingIncomebudgetMny(BigDecimal.ZERO);
        pcentity.setChangingLaborMny(BigDecimal.ZERO);
        pcentity.setChangingManageMny(BigDecimal.ZERO);
        pcentity.setChangingManageRate(BigDecimal.ZERO);
        pcentity.setChangingMaterialMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.budgetService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<IPage<BudgetChangeVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        IPage page = this.queryPage(param, false);
        List changeVOList = BeanMapper.mapList((Iterable)page.getRecords(), BudgetChangeVO.class);
        Page changeVOIPage = new Page();
        changeVOIPage.setCurrent(page.getCurrent());
        changeVOIPage.setRecords(changeVOList);
        changeVOIPage.setSize(page.getSize());
        changeVOIPage.setTotal(page.getTotal());
        changeVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)changeVOIPage);
    }
}

