/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.plan.bean.BudgetPlanChangeEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemChangeEntity;
import com.ejianc.business.plan.consts.ChangeStatusConst;
import com.ejianc.business.plan.service.IBudgetPlanChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetPlanChangeVO;
import com.ejianc.business.plan.vo.BudgetPlanItemTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetPlanChange"})
public class BudgetPlanChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROBUDGET_PLAN_CHANGE";
    @Autowired
    private IBudgetPlanChangeService service;
    @Autowired
    private IBudgetPlanService budgetPlanService;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;

    @RequestMapping(value={"/loadBudget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetTemVO> loadBudget(@RequestBody BudgetPlanChangeVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = this.budgetPlanService.getBudgetById(planVO.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)planVO.getStartMonth(), (String)planVO.getEndMonth());
        vo.setMonthColumn(months);
        vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getBudgetPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetPlanChangeVO> getBudgetPlan(Long id) {
        BudgetPlanEntity entity = (BudgetPlanEntity)((Object)this.budgetPlanService.selectById(id));
        BudgetPlanChangeVO planChangeVO = (BudgetPlanChangeVO)BeanMapper.map((Object)((Object)entity), BudgetPlanChangeVO.class);
        Long projectId = entity.getProjectId();
        CommonResponse<BudgetTemVO> budgetByProjectId = this.budgetPlanService.getBudgetVOByProjectId(projectId);
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)entity.getStartMonth(), (String)entity.getEndMonth());
        planChangeVO.setMonthColumn(months);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List detailIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("eq", (Object)id));
            param.getParams().put("detail_id", new Parameter("in", detailIds));
            List planItemEntities = this.budgetPlanItemService.queryList(param);
            List itemTemVOS = BeanMapper.mapList((Iterable)planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList((List)listMap.get(t.getId())));
            planChangeVO.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        planChangeVO.setId(null);
        planChangeVO.setChangeId(id);
        planChangeVO.setBillState(null);
        planChangeVO.setVersion(null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)planChangeVO);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetPlanChangeVO> saveOrUpdate(@RequestBody BudgetPlanChangeVO saveorUpdateVO) {
        BudgetPlanChangeEntity entity = (BudgetPlanChangeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetPlanChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveorUpdateVO.getDetailList();
        ArrayList itemList = new ArrayList();
        for (BudgetDetailTemVO v : detailList) {
            if (!CollectionUtils.isNotEmpty((Collection)v.getItemList())) continue;
            List budgetPlanItemEntities = BeanMapper.mapList((Iterable)v.getItemList(), BudgetPlanItemChangeEntity.class);
            itemList.addAll(budgetPlanItemEntities);
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(itemList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("in", (Object)entity.getId()));
            List oldItems = this.budgetPlanItemChangeService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)oldItems)) {
                Map<String, BudgetPlanItemChangeEntity> oldMap = oldItems.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), k -> k));
                itemList.forEach(t -> {
                    Long detailId = t.getDetailId();
                    t.setPlanId(entity.getId());
                    BudgetPlanItemChangeEntity oldVO = (BudgetPlanItemChangeEntity)((Object)((Object)oldMap.get(detailId + t.getYyearMonth())));
                    if (null != oldVO) {
                        t.setId(oldVO.getId());
                        t.setVersion(oldVO.getVersion());
                    }
                });
            } else {
                itemList.forEach(t -> t.setPlanId(entity.getId()));
            }
            this.budgetPlanItemChangeService.saveOrUpdateBatch(itemList);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getChangeId());
        updateWrapper.set(BudgetPlanEntity::getChangeStatus, (Object)ChangeStatusConst.CHANGING);
        updateWrapper.set(BudgetPlanEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(BudgetPlanEntity::getChangeCode, (Object)entity.getBillCode());
        this.budgetPlanService.update((Wrapper)updateWrapper);
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetPlanChangeVO> queryDetail(Long id) {
        BudgetPlanChangeEntity entity = (BudgetPlanChangeEntity)((Object)this.service.selectById(id));
        BudgetPlanChangeVO planVO = (BudgetPlanChangeVO)BeanMapper.map((Object)((Object)entity), BudgetPlanChangeVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = this.budgetPlanService.getBudgetById(entity.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)entity.getStartMonth(), (String)entity.getEndMonth());
        planVO.setMonthColumn(months);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List detailIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("eq", (Object)id));
            param.getParams().put("detail_id", new Parameter("in", detailIds));
            List planItemEntities = this.budgetPlanItemChangeService.queryList(param);
            List itemTemVOS = BeanMapper.mapList((Iterable)planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList((List)listMap.get(t.getId())));
            planVO.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)planVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetPlanChangeVO> vos) {
        List changeIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", changeIds);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(BudgetPlanChangeEntity::getChangeId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, ids);
            updateWrapper.set(BudgetPlanEntity::getChangeStatus, (Object)ChangeStatusConst.UN_CHANGE);
            updateWrapper.set(BudgetPlanEntity::getChangeId, null);
            updateWrapper.set(BudgetPlanEntity::getBillCode, null);
            this.budgetPlanService.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        QueryWrapper rapper = new QueryWrapper();
        rapper.in((Object)"plan_id", changeIds);
        this.budgetPlanItemChangeService.remove((Wrapper)rapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetPlanChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetPlanChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetPlanChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanChangeVO>> refBudgetPlanChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetPlanChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

