/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.material.api.IMaterialInstoreApi;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetPlanService")
public class BudgetPlanServiceImpl
extends BaseServiceImpl<BudgetPlanMapper, BudgetPlanEntity>
implements IBudgetPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static BigDecimal ONE_WAN = new BigDecimal("10000");
    private static BigDecimal ONE_BAI = new BigDecimal("100");
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    IMaterialInstoreApi materialInstoreApi;

    @Override
    public CommonResponse<BudgetTemVO> getBudgetVOByProjectId(Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.budgetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u751f\u6548\u7684\u9879\u76ee\u9884\u7b97\uff01");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)list.get(0));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"budget_id", (Object)budgetEntity.getId());
        wrapper.in((Object)"level_no", Arrays.asList(1, 2, 3));
        wrapper.orderByAsc((Object)"tree_index");
        List detailList = this.budgetDetailService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = (BudgetTemVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetTemVO.class);
        List resultMapList = BeanMapper.mapList((Iterable)detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CommonResponse<BudgetEntity> getBudgetByProjectId(Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.budgetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u751f\u6548\u7684\u9879\u76ee\u9884\u7b97\uff01");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)list.get(0));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"budget_id", (Object)budgetEntity.getId());
        wrapper.orderByAsc((Object)"tree_index");
        List detailList = this.budgetDetailService.list((Wrapper)wrapper);
        budgetEntity.setDetailList(detailList);
        return CommonResponse.success((Object)((Object)budgetEntity));
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetById(Long budgetId) {
        BudgetEntity budgetEntity = (BudgetEntity)((Object)this.budgetService.getById(budgetId));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"budget_id", (Object)budgetEntity.getId());
        wrapper.in((Object)"level_no", Arrays.asList(1, 2, 3));
        wrapper.orderByAsc((Object)"tree_index");
        List detailList = this.budgetDetailService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = (BudgetTemVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetTemVO.class);
        List resultMapList = BeanMapper.mapList((Iterable)detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CommonResponse<RecalculateVO> recalculate(RecalculateVO cal, int updateFlag) {
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = (BudgetEntity)((Object)this.budgetService.selectById(cal.getBudgetId()));
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = (BudgetEntity)((Object)budgetByProjectId.getData());
        }
        if (budgetEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u7684\u660e\u7ec6!");
        }
        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        if (level4Map == null || level4Map.isEmpty()) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u6750\u6599\u660e\u7ec6(\u56db\u7ea7)!");
        }
        BudgetPlanEntity budgetPlanEntity = this.getBudgetPlan(cal);
        if (budgetPlanEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212!");
        }
        if (updateFlag == 1) {
            String _endMonthDate;
            ArrayList<Long> level3Ids = new ArrayList<Long>(level3Map.keySet());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("eq", (Object)budgetPlanEntity.getId()));
            param.getParams().put("detail_id", new Parameter("in", level3Ids));
            String currentDay = DateUtil.getCurrentDay(null);
            String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
            String string = _endMonthDate = curMonth + "-" + budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "30";
            if (_endMonthDate.compareTo(currentDay) >= 0) {
                param.getParams().put("yyear_month", new Parameter("lt", (Object)curMonth));
            } else {
                param.getParams().put("yyear_month", new Parameter("le", (Object)curMonth));
            }
            List planItemEntities = this.budgetPlanItemService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)planItemEntities)) {
                planItemEntities.forEach(t -> t.setFinishRatio(ComputeUtil.bigDecimalPercent((BigDecimal)t.getFinishNum(), (BigDecimal)((BigDecimal)level3Map.get(t.getDetailId())), (int)8)));
                this.budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
            }
        }
        if (updateFlag > 2) {
            HashMap<Long, BigDecimal> level4BudgetNumMap = new HashMap<Long, BigDecimal>();
            level4Map.forEach((k, v) -> level4BudgetNumMap.put((Long)k, v.stream().filter(s -> s.getMaterialPlanNum() != null).map(BudgetDetailEntity::getMaterialPlanNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            List instoreMaterialVOS = null;
            if (updateFlag == 3) {
                HashMap<String, Object> queryParam = new HashMap<String, Object>();
                queryParam.put("projectId", cal.getProjectId());
                queryParam.put("materialIds", new ArrayList<Long>(level4Map.keySet()));
                String currentDay = DateUtil.getCurrentDay(null);
                String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
                String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
                String _endMonthDate = curMonth + "-" + endDay;
                if (_endMonthDate.compareTo(currentDay) >= 0) {
                    queryParam.put("endMonth", _endMonthDate);
                } else {
                    queryParam.put("endMonth", DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + endDay);
                }
                CommonResponse listCommonResponse = this.materialInstoreApi.instoreNumCount(queryParam);
                if (!listCommonResponse.isSuccess()) {
                    this.logger.error(listCommonResponse.getMsg());
                    return CommonResponse.error((String)listCommonResponse.getMsg());
                }
                instoreMaterialVOS = (List)listCommonResponse.getData();
            } else {
                instoreMaterialVOS = cal.getInstoreMaterialVOS();
            }
            if (CollectionUtils.isEmpty((Collection)instoreMaterialVOS)) {
                return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u7269\u8d44\u5165\u5e93\u6570\u91cf\u4fe1\u606f!");
            }
            Map<Long, BigDecimal> level4InstoreMap = instoreMaterialVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getInstoreNumber()));
            HashMap instoreBudgetMap = new HashMap();
            level4BudgetNumMap.forEach((k, v) -> instoreBudgetMap.put(k, ComputeUtil.isGreaterOrEqual((BigDecimal)((BigDecimal)level4InstoreMap.get(k)), (BigDecimal)v) ? BigDecimal.ONE : ComputeUtil.safeDiv((BigDecimal)((BigDecimal)level4InstoreMap.get(k)), (BigDecimal)v)));
            Map<Long, List<BudgetDetailEntity>> level3ChildMap = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getParentId));
            QueryParam p = new QueryParam();
            p.getParams().put("plan_id", new Parameter("eq", (Object)budgetPlanEntity.getId()));
            String currentDay1 = DateUtil.getCurrentDay(null);
            String curMonth1 = DateUtil.getCurrentDay((String)"yyyy-MM");
            String endDay1 = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            QueryWrapper pw = BudgetPlanServiceImpl.changeToQueryWrapper((QueryParam)p);
            if (_endMonthDate1.compareTo(currentDay1) >= 0) {
                String start = DateUtil.format((Date)DateUtil.minusMonths((long)1L), (String)"yyyy-MM") + "-" + endDay1;
                pw.apply("(yyear_month >= '" + start + "' and yyear_month < '" + _endMonthDate1 + "')", new Object[0]);
            } else {
                String end = DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + "-" + endDay1;
                pw.apply("(yyear_month >= '" + _endMonthDate1 + "' and yyear_month < '" + end + "')", new Object[0]);
            }
            List planItemEntities = this.budgetPlanItemService.list((Wrapper)pw);
            planItemEntities.forEach(t -> {
                Long detailId = t.getDetailId();
                List budgetDetailEntities = (List)level3ChildMap.get(detailId);
                if (CollectionUtils.isNotEmpty((Collection)budgetDetailEntities)) {
                    BigDecimal _subFinishRatio = BigDecimal.ZERO;
                    for (BudgetDetailEntity k : budgetDetailEntities) {
                        Long materialId = k.getMaterialId();
                        BigDecimal instoreNumBudgetNum = (BigDecimal)instoreBudgetMap.get(materialId);
                        BigDecimal b1 = ComputeUtil.safeMultiply((BigDecimal)instoreNumBudgetNum, (BigDecimal[])new BigDecimal[]{k.getMaterialUsedScale(), k.getMaterialWeightScale()});
                        _subFinishRatio = ComputeUtil.safeAdd((BigDecimal)_subFinishRatio, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)b1, (BigDecimal)ONE_WAN));
                    }
                    t.setFinishRatio(ComputeUtil.safeMultiply((BigDecimal)_subFinishRatio, (BigDecimal)ONE_BAI));
                    t.setFinishNum(ComputeUtil.safeMultiply((BigDecimal)_subFinishRatio, (BigDecimal)((BigDecimal)level3Map.get(detailId))));
                }
            });
            this.budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
        }
        return CommonResponse.success((String)"\u91cd\u65b0\u8ba1\u7b97\u9879\u76ee\u65bd\u5de5\u8ba1\u5212\u4fe1\u606f\u6210\u529f!");
    }

    private BudgetPlanEntity getBudgetPlan(RecalculateVO cal) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq((Object)"budget_id", (Object)cal.getBudgetId());
        } else {
            queryWrapper.eq((Object)"project_id", (Object)cal.getProjectId());
        }
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (BudgetPlanEntity)((Object)list.get(0));
    }

    @Override
    public CommonResponse<RecalculateVO> getInfo(RecalculateVO cal) {
        BudgetPlanEntity budgetPlanEntity = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq((Object)"budget_id", (Object)cal.getBudgetId());
        } else {
            queryWrapper.eq((Object)"project_id", (Object)cal.getProjectId());
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212!");
        }
        budgetPlanEntity = (BudgetPlanEntity)((Object)list.get(0));
        if (budgetPlanEntity.getBudgetId() == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212,\u8ba1\u5212\u4e2d\u7684\u9884\u7b97id\u4e3a\u7a7a!");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)this.budgetService.selectById(budgetPlanEntity.getBudgetId()));
        if (budgetEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u9884\u7b97!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u7684\u660e\u7ec6!");
        }
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("projectId", cal.getProjectId());
        queryParam.put("materialIds", new ArrayList<Long>(level4Map.keySet()));
        String currentDay = DateUtil.getCurrentDay(null);
        String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
        String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
        String _endMonthDate = curMonth + "-" + endDay;
        if (_endMonthDate.compareTo(currentDay) >= 0) {
            queryParam.put("endMonth", _endMonthDate);
        } else {
            queryParam.put("endMonth", DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + endDay);
        }
        cal.setQueryParam(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u548c\u65bd\u5de5\u8ba1\u5212\u6210\u529f!", (Object)cal);
    }
}

