package com.ejianc.business.budget.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/budget/")
public class BudgetApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IBudgetService budgetService;

    @Autowired
    IBudgetPlanService budgetPlanService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @GetMapping(value = "getLaborCostMny")
    public CommonResponse<BigDecimal> getLaborCostMny(@RequestParam("projectId") Long projectId, @RequestParam("settleDate") String settleDate) {
        LambdaQueryWrapper<BudgetEntity> budgetQuery = new LambdaQueryWrapper<>();
        budgetQuery.eq(BudgetEntity::getProjectId, projectId);
        List<BudgetEntity> budgetEntities = budgetService.list(budgetQuery);
        Map<Long, BigDecimal> budgetMap = new HashMap<>();
        BigDecimal totalMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(budgetEntities)){
            BudgetVO budgetVO = budgetService.queryDetail(budgetEntities.get(0).getId(), false);
            if(CollectionUtils.isNotEmpty(budgetVO.getDetailList())){
                for(BudgetDetailVO budgetDetailVO : budgetVO.getDetailList()){
                    budgetMap.put(budgetDetailVO.getId(), budgetDetailVO.getCostPrice());
                }
            }
        }

        LambdaQueryWrapper<BudgetPlanEntity> budgetPlanQuery = new LambdaQueryWrapper<>();
        budgetPlanQuery.eq(BudgetPlanEntity::getProjectId, projectId);
        List<BudgetPlanEntity> planEntities = budgetPlanService.list(budgetPlanQuery);
        if(CollectionUtils.isNotEmpty(planEntities)){
            LambdaQueryWrapper<BudgetPlanItemEntity> pw = new LambdaQueryWrapper<>();
            pw.eq(BudgetPlanItemEntity::getPlanId, planEntities.get(0).getId());
            String curMonth1 = getCalendar(settleDate);
            String endDay1 = planEntities.get(0).getMonthEndDate() != null ? planEntities.get(0).getMonthEndDate() : "31";
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            if (_endMonthDate1.compareTo(settleDate) >= 0) {
                pw.eq(BudgetPlanItemEntity::getYyearMonth, curMonth1);
            } else {
                //如果截止日期今天之前,那说明当前月是在下月
                String nextMonth = DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH);
                pw.eq(BudgetPlanItemEntity::getYyearMonth, nextMonth);
            }
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.list(pw);
            if(CollectionUtils.isNotEmpty(planItemEntities)){
                for(BudgetPlanItemEntity itemEntity : planItemEntities){
                    if(budgetMap.containsKey(itemEntity.getDetailId())){
                        totalMny = ComputeUtil.safeAdd(totalMny, ComputeUtil.safeMultiply(budgetMap.get(itemEntity.getDetailId()), itemEntity.getFinishNum()));
                    }
                }
            }
        }
        return CommonResponse.success("查询人工成本成功", totalMny);
    }

    private String getCalendar(String settleDate){
        String ca;
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(settleDate );
            ca = new SimpleDateFormat("yyyy-MM").format(date);
        } catch (ParseException e) {
            throw new BusinessException("日期转换错误");
        }
        return ca;
    }

}
