package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.bean.BudgetRecordEntity;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("budgetChange")
public class BudgetChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBudgetChangeService budgetChangeService;

	@Autowired
	private IBudgetService budgetService;

	@Autowired
	private IBudgetDetailService budgetDetailService;

	@Autowired
	private IBudgetRecordService recordService;

	@Autowired
	private IBudgetPlanService service;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
/**更新变更的审批时间  begin */
		BudgetChangeEntity budgetChangeEntity = budgetChangeService.selectById(billId);
		LambdaUpdateWrapper<BudgetChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(BudgetChangeEntity::getUsedTime, new Date());
		updateWrapper.eq(BudgetChangeEntity::getId, budgetChangeEntity.getId());
		budgetChangeService.update(budgetChangeEntity, updateWrapper, false);
		/**更新变更的审批时间  end */

		/**复制合同表数据到记录表 begin */
		BudgetVO budgetVO = budgetService.queryDetail(budgetChangeEntity.getBudgetId(), false);
		Map<Long, Integer> contIdVersionMap =  new HashMap<>();
		BudgetRecordEntity recordEntity = BeanMapper.map(budgetVO, BudgetRecordEntity.class);
		recordEntity.setBudgetId(recordEntity.getId());
		recordEntity.setId(null);
		if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
			recordEntity.getDetailList().forEach(vo -> {
				contIdVersionMap.put(vo.getId(), vo.getVersion());
				vo.setBudgetDetailId(vo.getId());
				vo.setId(null);
			});
		}
		recordService.saveOrUpdate(recordEntity, false);
		/**复制合同表数据到记录表 end */

		/**更新变更表表头数据到合同 begin */
		BudgetEntity budgetEntity = BeanMapper.map(budgetVO, BudgetEntity.class);
		budgetEntity.setBillCode(budgetChangeEntity.getBillCode());
		budgetEntity.setMemo(budgetChangeEntity.getMemo());
		budgetEntity.setCostbudgetMny(budgetChangeEntity.getCostbudgetMny());
		budgetEntity.setIncomebudgetAdjustMny(budgetChangeEntity.getIncomebudgetAdjustMny());
		budgetEntity.setIncomebudgetMny(budgetChangeEntity.getIncomebudgetMny());
		budgetEntity.setLaborMny(budgetChangeEntity.getLaborMny());
		budgetEntity.setManageMny(budgetChangeEntity.getManageMny());
		budgetEntity.setManageRate(budgetChangeEntity.getManageRate());
		budgetEntity.setMaterialMny(budgetChangeEntity.getMaterialMny());
		budgetEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
		budgetService.updateById(budgetEntity);
		/**复制合同表数据到记录表 end */

		/**复制合同子表数据到记录表 begin */
		BudgetEntity budgetEntity1 = BeanMapper.map(budgetChangeEntity, BudgetEntity.class);
		List<BudgetDetailEntity> budgetDetailEntities = budgetEntity1.getDetailList();
		if(CollectionUtils.isNotEmpty(budgetDetailEntities)){
			budgetDetailEntities.forEach(budgetDetailEntity -> {
				//记录虚拟父子关系
				budgetDetailEntity.setTid(budgetDetailEntity.getId().toString());
				budgetDetailEntity.setTpid(budgetDetailEntity.getParentId() != null && budgetDetailEntity.getParentId() > 0 ? budgetDetailEntity.getParentId().toString() : "");
				Long contractBid = budgetDetailEntity.getSrcBid();
				budgetDetailEntity.setBudgetId(budgetChangeEntity.getBudgetId());
				budgetDetailEntity.setSrcBid(budgetDetailEntity.getId());
				budgetDetailEntity.setId(contractBid);
				budgetDetailEntity.setVersion(contIdVersionMap.get(contractBid));
			});
			budgetDetailService.saveOrUpdateBatch(budgetDetailEntities, budgetDetailEntities.size(), false);

			//根据更新后数据维护树形关系
			Map<String,Long> idMap=new HashMap<>();
			budgetDetailEntities.forEach(cdEntity ->{
				idMap.put(cdEntity.getTid(),cdEntity.getId());
			});

			budgetDetailEntities.forEach(cdEntity ->{
				if(StringUtils.isNotEmpty(cdEntity.getTpid())){
					cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
				}
			});

			// 生成结构码、内码、逻辑内码
			List<Map> resultMapList = BeanMapper.mapList(budgetDetailEntities, Map.class);
			List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
			List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
			List<BudgetDetailEntity> saveEntities = new ArrayList<>();
			treeToList(ListCodeDate, saveEntities);
			budgetDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);

		}
		//预算变更回写 计划
		service.recalculate(RecalculateVO.intsance(null, budgetChangeEntity.getBudgetId()), 1);
		return CommonResponse.success();
	}

	/**
	 * 生成内码
	 *
	 * @param list
	 * @param innerCode
	 * @return
	 */
	private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> ypd = list.get(i);
			// 生成内码
			if (StringUtils.isNotEmpty(innerCode)) {
				ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
			} else {
				ypd.put("innerCode", ypd.get("id"));
			}

			if (ypd.get("children") != null) {
				List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"),  ypd.get("innerCode").toString());
				ypd.put("children", child);
				ypd.put("leafFlag", false);
			}else {
				ypd.put("leafFlag", true);
			}
		}
		return list;
	}

	private void treeToList(List<Map<String, Object>> list, List<BudgetDetailEntity> entities){
		for (Map<String, Object> ypd : list) {
			if (ypd.get("children") != null) {
				treeToList((List) ypd.get("children"), entities);
			}
			entities.add(BeanMapper.map(ypd, BudgetDetailEntity.class));
		}
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
