/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetSubRefVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.utils.BigDecimalUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budget"})
public class BudgetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IBudgetRecordService budgetRecordService;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IMaterialApi materialApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetVO> saveOrUpdate(@RequestBody BudgetVO saveorUpdateVO) {
        BudgetVO vo = this.budgetService.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetVO> queryDetail(Long id) {
        BudgetVO vo = this.budgetService.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryRecordDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetVO> queryRecordDetail(Long id) {
        BudgetVO vo = this.budgetRecordService.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.budgetService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.budgetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.budgetService.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Budget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-detail-import.xlsx", (String)"\u9884\u7b97\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.budgetService.excelImport(request, response);
    }

    @RequestMapping(value={"/budgetRefData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetDetailEntity>> budgetRefData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.budgetService.queryPage(queryParam, false);
        List records = pageData.getRecords();
        IPage<BudgetDetailEntity> budgetDetailEntityIPage = new IPage<BudgetDetailEntity>();
        for (BudgetEntity budget : records) {
            queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)budget.getId()));
            queryParam.getParams().put("level_no", new Parameter("eq", (Object)4));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)ChangeTypeEnum.\u4e2d\u6b62.getCode()));
            queryParam.getFuzzyFields().add("materialName");
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.setSearchText(searchText);
            }
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setPageIndex(pageNumber.intValue());
            Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
            budgetDetailEntityIPage = this.budgetDetailService.queryPageList((Page<BudgetDetailEntity>)page, queryParam);
            ArrayList ids = new ArrayList();
            budgetDetailEntityIPage.getRecords().forEach(budgetDetail -> ids.add(budgetDetail.getMaterialId()));
            CommonResponse result = this.materialApi.queryMaterialByIds(ids);
            if (result.getCode() != 0) continue;
            List data = (List)result.getData();
            for (BudgetDetailEntity budgetDetail2 : budgetDetailEntityIPage.getRecords()) {
                for (MaterialVO material : data) {
                    if (!budgetDetail2.getMaterialId().equals(material.getId())) continue;
                    budgetDetail2.setMaterialCategoryId(material.getCategoryId());
                    budgetDetail2.setMaterialCategoryName(material.getCategoryName());
                    budgetDetail2.setSpec(material.getSpec());
                    budgetDetail2.setUnitName(material.getUnitName());
                    budgetDetail2.setMaterialPrice(BigDecimalUtil.safeDiv(budgetDetail2.getSumMoney(), budgetDetail2.getSumNum()));
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)budgetDetailEntityIPage);
    }

    @RequestMapping(value={"/budgetRefForSub"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetSubRefVO>> budgetRefForSub(@RequestParam(value="projectId") Long projectId) {
        List<BudgetSubRefVO> result = new ArrayList();
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper budgetQuery = new LambdaQueryWrapper();
        budgetQuery.in(BudgetEntity::getBillState, billStateList);
        budgetQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        budgetQuery.eq(BudgetEntity::getProjectId, (Object)projectId);
        budgetQuery.in(BudgetEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        List budgetEntities = this.budgetService.list((Wrapper)budgetQuery);
        if (CollectionUtils.isEmpty((Collection)budgetEntities)) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u9884\u7b97\uff01");
        }
        ArrayList<Integer> levelList = new ArrayList<Integer>();
        levelList.add(1);
        levelList.add(2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("budget_id", new Parameter("eq", (Object)((BudgetEntity)((Object)budgetEntities.get(0))).getId()));
        queryParam.getParams().put("level_no", new Parameter("in", levelList));
        queryParam.getParams().put("changeType", new Parameter("ne", (Object)ChangeTypeEnum.\u4e2d\u6b62.getCode()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.budgetDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (int i = 0; i < detailEntityList.size(); ++i) {
                BudgetDetailEntity cdEntity = (BudgetDetailEntity)((Object)detailEntityList.get(i));
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                BudgetSubRefVO subRefVO = (BudgetSubRefVO)BeanMapper.map((Object)((Object)cdEntity), BudgetSubRefVO.class);
                int num = i + 1;
                if (i < 9) {
                    subRefVO.setCode("0" + num);
                } else {
                    subRefVO.setCode(String.valueOf(num));
                }
                subRefVO.setName(StringUtils.isNotBlank((CharSequence)cdEntity.getBuildingNo()) ? cdEntity.getBuildingNo() : cdEntity.getBuildContent());
                subRefVO.setNum(cdEntity.getCostNum());
                subRefVO.setBudgetDetailId(cdEntity.getId());
                result.add(subRefVO);
            }
            result = TreeNodeBUtil.buildTree(result);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/budgetDetailRefData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetDetailEntity>> budgetDetailRefData(@RequestParam(value="budgetId") Long budgetId) {
        Page budgetDetailEntityIPage = new Page();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("budget_id", new Parameter("eq", (Object)budgetId));
        queryParam.getParams().put("level_no", new Parameter("eq", (Object)1));
        queryParam.getParams().put("changeType", new Parameter("ne", (Object)ChangeTypeEnum.\u4e2d\u6b62.getCode()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.budgetDetailService.queryList(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)detailEntityList);
    }
}

