/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetRecordDetailEntity;
import com.ejianc.business.budget.bean.BudgetRecordEntity;
import com.ejianc.business.budget.mapper.BudgetRecordMapper;
import com.ejianc.business.budget.service.IBudgetRecordDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetRecordService")
public class BudgetRecordServiceImpl
extends BaseServiceImpl<BudgetRecordMapper, BudgetRecordEntity>
implements IBudgetRecordService {
    @Autowired
    IBudgetRecordDetailService budgetRecordDetailService;

    @Override
    public BudgetVO queryDetail(Long id, Boolean detailHasChildren) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BudgetRecordEntity::getChangeId, (Object)id);
        BudgetRecordEntity budgetRecordEntity = (BudgetRecordEntity)((Object)super.getOne((Wrapper)lambda));
        BudgetVO budgetVO = (BudgetVO)BeanMapper.map((Object)((Object)budgetRecordEntity), BudgetVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter("eq", (Object)budgetRecordEntity.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.budgetRecordDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (BudgetRecordDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getBudgetDetailId().toString());
                cdEntity.setId(cdEntity.getBudgetDetailId());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, BudgetDetailVO.class);
            if (detailHasChildren.booleanValue()) {
                budgetVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                budgetVO.setDetailList(resultMapList);
            }
        }
        return budgetVO;
    }
}

