package com.ejianc.business.plan.service;

import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.plan.bean.BudgetPlanEntity;

import java.util.List;

/**
 * 施工计划
 *
 * @author generator
 */
public interface IBudgetPlanService extends IBaseService<BudgetPlanEntity> {

    CommonResponse<BudgetTemVO> getBudgetVOByProjectId(Long projectId);

    CommonResponse<BudgetEntity> getBudgetByProjectId(Long projectId);

    CommonResponse<BudgetTemVO> getBudgetById(Long budgetId);


    /**
     * @param cal
     * @param updateFlag
     * @description: 计算vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.RecalculateVO>
     * @author songlx
     * @date: 2021/9/10
     */
    CommonResponse<RecalculateVO> recalculate(RecalculateVO cal, int updateFlag);

    void createNewPlanItem(Long budgetId);

    CommonResponse<RecalculateVO> getInfo(RecalculateVO vo);

    CommonResponse<RecalculateVO> getPlanNum(RecalculateVO vo);

    CommonResponse updateDataByDay(String day);
}
