/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetPlanItemTemVO;
import com.ejianc.business.plan.vo.BudgetPlanVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.business.utils.CheckUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetPlan"})
public class BudgetPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROBUDGET_PLAN";
    @Autowired
    private IBudgetPlanService service;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    ICommonBusinessService budgetChange;

    @RequestMapping(value={"/rec1"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecalculateVO> rec1(@RequestBody RecalculateVO vo) {
        this.budgetChange.afterApprovalProcessor(vo.getProjectId(), null, null);
        return null;
    }

    @RequestMapping(value={"/rec"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecalculateVO> rec(@RequestBody RecalculateVO vo) {
        return this.service.recalculate(vo, 2);
    }

    @RequestMapping(value={"/loadBudget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetTemVO> loadBudget(@RequestBody BudgetPlanVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = this.service.getBudgetVOByProjectId(planVO.getProjectId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)planVO.getStartMonth(), (String)planVO.getEndMonth());
        vo.setMonthColumn(months);
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            for (BudgetDetailTemVO cdEntity : vo.getDetailList()) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetPlanVO> saveOrUpdate(@RequestBody BudgetPlanVO saveorUpdateVO) {
        RecalculateVO vo;
        CommonResponse<RecalculateVO> recalculate;
        BudgetPlanEntity entity = (BudgetPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetPlanEntity.class));
        List detailList = saveorUpdateVO.getDetailList();
        ArrayList<BudgetPlanItemEntity> itemList = new ArrayList<BudgetPlanItemEntity>();
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        ArrayList<Long> buildingNos = new ArrayList<Long>();
        for (BudgetDetailTemVO v : detailList) {
            List vItemList;
            if (v.getLevelNo() == 1) {
                buildingNos.add(v.getId());
            }
            if (!CollectionUtils.isNotEmpty((Collection)(vItemList = v.getItemList()))) continue;
            selectedIds.add(v.getId());
            List budgetPlanItemEntities = BeanMapper.mapList((Iterable)vItemList, BudgetPlanItemEntity.class);
            itemList.addAll(budgetPlanItemEntities);
        }
        List<BudgetPlanItemEntity> budgetPlanItemEntities = this.budgetPlanItemService.queryByNotIds(selectedIds, saveorUpdateVO.getId());
        if (null != budgetPlanItemEntities && 0 < budgetPlanItemEntities.size()) {
            itemList.addAll(budgetPlanItemEntities);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"project_id", (Object)saveorUpdateVO.getProjectId());
            List list = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u65bd\u5de5\u8ba1\u5212\uff01");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(itemList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("eq", (Object)entity.getId()));
            List oldItems = this.budgetPlanItemService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)oldItems)) {
                Map<String, BudgetPlanItemEntity> oldMap = oldItems.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), k -> k));
                itemList.forEach(t -> {
                    Long detailId = t.getDetailId();
                    t.setPlanId(entity.getId());
                    BudgetPlanItemEntity oldVO = (BudgetPlanItemEntity)((Object)((Object)oldMap.get(detailId + t.getYyearMonth())));
                    if (null != oldVO) {
                        t.setId(oldVO.getId());
                        t.setVersion(oldVO.getVersion());
                        t.setCreateTime(oldVO.getCreateTime());
                        t.setCreateUserCode(oldVO.getCreateUserCode());
                        oldMap.remove(detailId + t.getYyearMonth());
                    }
                });
                if (MapUtils.isNotEmpty(oldMap)) {
                    List ids = oldMap.values().stream().map(BaseEntity::getId).collect(Collectors.toList());
                    this.budgetPlanItemService.removeByIds(ids);
                }
            } else {
                itemList.forEach(t -> t.setPlanId(entity.getId()));
            }
            this.budgetPlanItemService.saveOrUpdateBatch(itemList);
        }
        if (!(recalculate = this.service.recalculate(vo = new RecalculateVO(entity.getProjectId(), null), 3)).isSuccess()) {
            this.logger.error(recalculate.getMsg());
        }
        if (buildingNos.size() == 0) {
            return this.queryDetail(entity.getId());
        }
        return this.queryDetailByBuildingNo(entity.getId(), buildingNos);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetPlanVO> queryDetail(Long id) {
        BudgetPlanEntity entity = (BudgetPlanEntity)((Object)this.service.selectById(id));
        BudgetPlanVO planVO = (BudgetPlanVO)BeanMapper.map((Object)((Object)entity), BudgetPlanVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = this.service.getBudgetById(entity.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)entity.getStartMonth(), (String)entity.getEndMonth());
        planVO.setMonthColumn(months);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            QueryParam param = new QueryParam();
            List detailIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("plan_id", new Parameter("eq", (Object)id));
            param.getParams().put("detail_id", new Parameter("in", detailIds));
            List planItemEntities = this.budgetPlanItemService.queryList(param);
            List itemTemVOS = BeanMapper.mapList((Iterable)planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList((List)listMap.get(t.getId())));
            planVO.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(1, entity.getId(), entity.getBudgetId());
        planVO.setUninBuildingNos(uninBuildingNos);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)planVO);
    }

    @RequestMapping(value={"/queryDetailByBuildingNo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetPlanVO> queryDetailByBuildingNo(@RequestParam(value="id") Long id, @RequestParam(value="buildingNos") List<Long> buildingNos) {
        BudgetPlanEntity entity = (BudgetPlanEntity)((Object)this.service.selectById(id));
        BudgetPlanVO planVO = (BudgetPlanVO)BeanMapper.map((Object)((Object)entity), BudgetPlanVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = this.service.getBudgetByIdAndBuildingNos(entity.getBudgetId(), buildingNos);
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)entity.getStartMonth(), (String)entity.getEndMonth());
        planVO.setMonthColumn(months);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            QueryParam param = new QueryParam();
            List detailIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("plan_id", new Parameter("eq", (Object)id));
            param.getParams().put("detail_id", new Parameter("in", detailIds));
            List planItemEntities = this.budgetPlanItemService.queryList(param);
            List itemTemVOS = BeanMapper.mapList((Iterable)planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList((List)listMap.get(t.getId())));
            planVO.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(1, entity.getId(), entity.getBudgetId());
        planVO.setUninBuildingNos(uninBuildingNos);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)planVO);
    }

    @RequestMapping(value={"/reloadBudget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetTemVO> reloadBudget(@RequestBody BudgetPlanVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = this.service.getBudgetVOByProjectIdAndKeys(planVO.getProjectId(), planVO.getSelectedKeys());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error((String)budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = (BudgetTemVO)budgetByProjectId.getData();
        List months = DateUtil.getMonthBetween((String)planVO.getStartMonth(), (String)planVO.getEndMonth());
        vo.setMonthColumn(months);
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            for (BudgetDetailTemVO cdEntity : vo.getDetailList()) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetPlanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        List planIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper rapper = new QueryWrapper();
        rapper.in((Object)"plan_id", planIds);
        this.budgetPlanItemService.remove((Wrapper)rapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanVO>> refBudgetPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

