/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.BudgetPlanChangeEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemRecordEntity;
import com.ejianc.business.plan.bean.BudgetPlanRecordEntity;
import com.ejianc.business.plan.consts.ChangeStatusConst;
import com.ejianc.business.plan.service.IBudgetPlanChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemRecordService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanRecordService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.utils.CheckUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetPlanChange")
public class BudgetPlanChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBudgetPlanChangeService budgetPlanChangeService;
    @Autowired
    private IBudgetPlanService budgetPlanService;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;
    @Autowired
    private IBudgetPlanRecordService budgetPlanRecordService;
    @Autowired
    private IBudgetPlanItemRecordService budgetPlanItemRecordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetPlanChangeEntity budgetPlanChangeEntity = (BudgetPlanChangeEntity)((Object)this.budgetPlanChangeService.selectById(billId));
        List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(2, budgetPlanChangeEntity.getChangeId(), budgetPlanChangeEntity.getBudgetId());
        if (uninBuildingNos.size() > 0) {
            String msg = "\u8be5\u8ba1\u5212\u4e0b\uff0c\u8fd8\u6709\u697c\u53f7(";
            for (String str : uninBuildingNos) {
                msg = msg + str + ",";
            }
            msg = msg.substring(0, msg.length() - 1);
            msg = msg + "),\u672a\u8fdb\u884c\u7f16\u8f91\uff0c\u8bf7\u7f16\u8f91\u4fdd\u5b58\u540e,\u4e00\u5e76\u63d0\u4ea4\uff01";
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetPlanChangeEntity changeEntity = (BudgetPlanChangeEntity)((Object)this.budgetPlanChangeService.getById(billId));
        QueryParam p = new QueryParam();
        p.getParams().put("plan_id", new Parameter("eq", (Object)billId));
        List budgetPlanItemChangeEntities = this.budgetPlanItemChangeService.queryList(p);
        Long id = changeEntity.getChangeId();
        BudgetPlanEntity plan = (BudgetPlanEntity)((Object)this.budgetPlanService.getById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("plan_id", new Parameter("eq", (Object)plan.getId()));
        List planItemEntities = this.budgetPlanItemService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)budgetPlanItemChangeEntities)) {
            ArrayList newItemEntities = new ArrayList();
            Map<String, BudgetPlanItemEntity> oldMap = planItemEntities.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), k -> k));
            budgetPlanItemChangeEntities.forEach(t -> {
                String key = t.getDetailId() + t.getYyearMonth();
                BudgetPlanItemEntity budgetPlanItemEntity = (BudgetPlanItemEntity)((Object)((Object)oldMap.get(key)));
                if (budgetPlanItemEntity != null) {
                    budgetPlanItemEntity.setPlanNum(t.getPlanNum());
                    budgetPlanItemEntity.setPlanRatio(t.getPlanRatio());
                    newItemEntities.add(budgetPlanItemEntity);
                    oldMap.remove(key);
                } else {
                    t.setId(null);
                    t.setPlanId(plan.getId());
                    t.setVersion(null);
                    newItemEntities.add(BeanMapper.map((Object)t, BudgetPlanItemEntity.class));
                }
            });
            this.budgetPlanItemService.saveOrUpdateBatch(newItemEntities);
            if (oldMap != null && oldMap.size() > 0) {
                ArrayList<BudgetPlanItemEntity> delItemList = new ArrayList<BudgetPlanItemEntity>(oldMap.values());
                this.budgetPlanItemService.removeByIds(delItemList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
        }
        BudgetPlanRecordEntity rec = (BudgetPlanRecordEntity)((Object)BeanMapper.map((Object)((Object)plan), BudgetPlanRecordEntity.class));
        rec.setId(null);
        this.budgetPlanRecordService.saveOrUpdate((Object)rec);
        if (CollectionUtils.isNotEmpty((Collection)planItemEntities)) {
            planItemEntities.forEach(t -> {
                t.setId(null);
                t.setPlanId(rec.getId());
                t.setVersion(null);
            });
            List budgetPlanItemRecordEntities = BeanMapper.mapList((Iterable)planItemEntities, BudgetPlanItemRecordEntity.class);
            this.budgetPlanItemRecordService.saveOrUpdateBatch(budgetPlanItemRecordEntities);
        }
        plan.setChangeStatus(ChangeStatusConst.CHANGED);
        plan.setChangeId(billId);
        plan.setEndMonth(changeEntity.getEndMonth());
        plan.setMonthEndDate(changeEntity.getMonthEndDate());
        plan.setChangeCode(changeEntity.getBillCode());
        this.budgetPlanService.updateById((Object)plan);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u65bd\u5de5\u8ba1\u5212\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

