/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.vo.BudgetChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetChange"})
public class BudgetChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetChangeService budgetChangeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetChangeVO> saveOrUpdate(@RequestBody BudgetChangeVO changeVO) {
        BudgetChangeVO vo = this.budgetChangeService.insertOrUpdate(changeVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetChangeVO> addConvertByConId(Long budgetId) {
        BudgetChangeVO vo = this.budgetChangeService.addConvertByConId(budgetId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetChangeVO> queryDetail(Long id) {
        BudgetChangeVO vo = this.budgetChangeService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetChangeVO> vos) {
        return this.budgetChangeService.deleteByIds(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetChangeVO>> queryList(@RequestBody QueryParam param) {
        return this.budgetChangeService.queryListVOs(param);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-detail-import.xlsx", (String)"\u9884\u7b97\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="budgetChangeId") String budgetChangeId, @RequestParam(value="budgetId") String budgetId) {
        return this.budgetChangeService.excelImport(request, response, budgetChangeId, budgetId);
    }
}

