/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/budget/"})
public class BudgetApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IBudgetService budgetService;
    @Autowired
    IBudgetPlanService budgetPlanService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @GetMapping(value={"getLaborCostMny"})
    public CommonResponse<BigDecimal> getLaborCostMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="settleDate") String settleDate) {
        BudgetVO budgetVO;
        LambdaQueryWrapper budgetQuery = new LambdaQueryWrapper();
        budgetQuery.eq(BudgetEntity::getProjectId, (Object)projectId);
        List budgetEntities = this.budgetService.list((Wrapper)budgetQuery);
        HashMap<Long, BigDecimal> budgetMap = new HashMap<Long, BigDecimal>();
        BigDecimal totalMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)budgetEntities) && CollectionUtils.isNotEmpty((Collection)(budgetVO = this.budgetService.queryDetail(((BudgetEntity)((Object)budgetEntities.get(0))).getId(), false)).getDetailList())) {
            for (BudgetDetailVO budgetDetailVO : budgetVO.getDetailList()) {
                budgetMap.put(budgetDetailVO.getId(), budgetDetailVO.getCostPrice());
            }
        }
        LambdaQueryWrapper budgetPlanQuery = new LambdaQueryWrapper();
        budgetPlanQuery.eq(BudgetPlanEntity::getProjectId, (Object)projectId);
        List planEntities = this.budgetPlanService.list((Wrapper)budgetPlanQuery);
        if (CollectionUtils.isNotEmpty((Collection)planEntities)) {
            LambdaQueryWrapper pw = new LambdaQueryWrapper();
            pw.eq(BudgetPlanItemEntity::getPlanId, (Object)((BudgetPlanEntity)((Object)planEntities.get(0))).getId());
            String curMonth1 = this.getCalendar(settleDate);
            String endDay1 = ((BudgetPlanEntity)((Object)planEntities.get(0))).getMonthEndDate() != null ? ((BudgetPlanEntity)((Object)planEntities.get(0))).getMonthEndDate() : "31";
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            String endMonth = ((BudgetPlanEntity)((Object)planEntities.get(0))).getEndMonth();
            if (endMonth.compareTo(curMonth1) < 0) {
                pw.eq(BudgetPlanItemEntity::getYyearMonth, (Object)endMonth);
            } else if (_endMonthDate1.compareTo(settleDate) >= 0) {
                pw.eq(BudgetPlanItemEntity::getYyearMonth, (Object)curMonth1);
            } else {
                String nextMonth = DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM");
                pw.eq(BudgetPlanItemEntity::getYyearMonth, (Object)nextMonth);
            }
            List planItemEntities = this.budgetPlanItemService.list((Wrapper)pw);
            if (CollectionUtils.isNotEmpty((Collection)planItemEntities)) {
                for (BudgetPlanItemEntity itemEntity : planItemEntities) {
                    if (!budgetMap.containsKey(itemEntity.getDetailId())) continue;
                    totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)budgetMap.get(itemEntity.getDetailId())), (BigDecimal)itemEntity.getFinishNum()));
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5de5\u6210\u672c\u6210\u529f", (Object)totalMny);
    }

    public static void main(String[] args) {
        String settleDate = "2022-04";
        String curMonth1 = "2022-08";
        int i = settleDate.compareTo(curMonth1);
        System.out.println(i);
    }

    private String getCalendar(String settleDate) {
        String ca;
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(settleDate);
            ca = new SimpleDateFormat("yyyy-MM").format(date);
        }
        catch (ParseException e) {
            throw new BusinessException("\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
        }
        return ca;
    }
}

