/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.bean.BudgetRecordEntity;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BudgetChangeThread
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetChangeService budgetChangeService;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IBudgetRecordService recordService;
    @Autowired
    private IBudgetPlanService service;
    private Long billId;

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    @Override
    public void run() {
        this.doSomething();
    }

    public void doSomething() {
        this.logger.info("\u56de\u8c03\u7ebf\u7a0b\u5f00\u59cb\u6267\u884c\uff1a" + this.billId.toString());
        Date startDate = new Date();
        BudgetChangeEntity budgetChangeEntity = (BudgetChangeEntity)((Object)this.budgetChangeService.selectById(this.billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetChangeEntity::getUsedTime, (Object)new Date());
        updateWrapper.eq(BaseEntity::getId, (Object)budgetChangeEntity.getId());
        this.budgetChangeService.update((Object)budgetChangeEntity, (Wrapper)updateWrapper, false);
        BudgetVO budgetVO = this.budgetService.queryDetail(budgetChangeEntity.getBudgetId(), false);
        HashMap contIdVersionMap = new HashMap();
        BudgetRecordEntity recordEntity = (BudgetRecordEntity)((Object)BeanMapper.map((Object)budgetVO, BudgetRecordEntity.class));
        recordEntity.setBudgetId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setBudgetDetailId(vo.getId());
                vo.setId(null);
            });
        }
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        BudgetEntity budgetEntity = (BudgetEntity)((Object)BeanMapper.map((Object)budgetVO, BudgetEntity.class));
        budgetEntity.setBillCode(budgetChangeEntity.getBillCode());
        budgetEntity.setMemo(budgetChangeEntity.getMemo());
        budgetEntity.setCostbudgetMny(budgetChangeEntity.getCostbudgetMny());
        budgetEntity.setIncomebudgetAdjustMny(budgetChangeEntity.getIncomebudgetAdjustMny());
        budgetEntity.setIncomebudgetMny(budgetChangeEntity.getIncomebudgetMny());
        budgetEntity.setLaborMny(budgetChangeEntity.getLaborMny());
        budgetEntity.setManageMny(budgetChangeEntity.getManageMny());
        budgetEntity.setManageRate(budgetChangeEntity.getManageRate());
        budgetEntity.setMaterialMny(budgetChangeEntity.getMaterialMny());
        budgetEntity.setTaxRatio(budgetChangeEntity.getTaxRatio());
        budgetEntity.setTaxFee(budgetChangeEntity.getTaxFee());
        budgetEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        this.budgetService.updateById((Object)budgetEntity);
        BudgetEntity budgetEntity1 = (BudgetEntity)((Object)BeanMapper.map((Object)((Object)budgetChangeEntity), BudgetEntity.class));
        List<BudgetDetailEntity> budgetDetailEntities = budgetEntity1.getDetailList();
        if (CollectionUtils.isNotEmpty(budgetDetailEntities)) {
            budgetDetailEntities.forEach(budgetDetailEntity -> {
                budgetDetailEntity.setTid(budgetDetailEntity.getId().toString());
                budgetDetailEntity.setTpid(budgetDetailEntity.getParentId() != null && budgetDetailEntity.getParentId() > 0L ? budgetDetailEntity.getParentId().toString() : "");
                Long contractBid = budgetDetailEntity.getSrcBid();
                budgetDetailEntity.setBudgetId(budgetChangeEntity.getBudgetId());
                budgetDetailEntity.setSrcBid(budgetDetailEntity.getId());
                budgetDetailEntity.setId(contractBid);
                budgetDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
            });
            this.budgetDetailService.saveOrUpdateBatch(budgetDetailEntities, budgetDetailEntities.size(), false);
            HashMap idMap = new HashMap();
            budgetDetailEntities.forEach(cdEntity -> idMap.put(cdEntity.getTid(), cdEntity.getId()));
            budgetDetailEntities.forEach(cdEntity -> {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
            });
            List resultMapList = BeanMapper.mapList(budgetDetailEntities, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> ListCodeDate = this.creatInnerCode(treeData, null);
            ArrayList<BudgetDetailEntity> saveEntities = new ArrayList<BudgetDetailEntity>();
            this.treeToList(ListCodeDate, saveEntities);
            this.budgetDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
        }
        this.logger.info("\u5f00\u59cb\u6267\u884c\u56de\u5199\u8ba1\u5212\u64cd\u4f5c");
        CommonResponse<RecalculateVO> recalculate = this.service.recalculate(RecalculateVO.intsance(null, (Long)budgetChangeEntity.getBudgetId()), 1);
        if (!recalculate.isSuccess()) {
            this.logger.info("recalculate\u6267\u884c\u9519\u8bef\uff01" + recalculate.getMsg());
        }
        this.logger.info("\u5f00\u59cb\u6267\u884c\u521b\u5efa\u65b0\u7684\u8ba1\u5212\u660e\u7ec6\u64cd\u4f5c");
        this.service.createNewPlanItem(budgetChangeEntity.getBudgetId());
        Date endDate = new Date();
        this.logger.info("\u9884\u7b97\u53d8\u66f4\u63d0\u4ea4\u540e\u56de\u8c03\u51fd\u6570\u6267\u884c\u90fd\u5df2\u5b8c\u6210\uff0c\u8017\u65f6" + (endDate.getTime() - startDate.getTime()));
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((BudgetDetailEntity)((Object)BeanMapper.map(ypd, BudgetDetailEntity.class)));
        }
    }
}

