/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.consts.ChangeStatusConst;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.business.utils.CheckUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetPlan")
public class BudgetPlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBudgetPlanService budgetPlanService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u65bd\u5de5\u8ba1\u5212\u63d0\u4ea4\u524d\u56de\u8c03");
        BudgetPlanEntity entity = (BudgetPlanEntity)((Object)this.budgetPlanService.selectById(billId));
        CommonResponse planItem = CheckUtil.createPlanItem(entity.getId(), entity.getBudgetId(), entity.getStartMonth(), entity.getEndMonth());
        RecalculateVO vo = new RecalculateVO(entity.getProjectId(), null);
        this.budgetPlanService.recalculate(vo, 3);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetPlanEntity entity = (BudgetPlanEntity)((Object)this.budgetPlanService.selectById(billId));
        CommonResponse planItem = CheckUtil.createPlanItem(entity.getId(), entity.getBudgetId(), entity.getStartMonth(), entity.getEndMonth());
        RecalculateVO vo = new RecalculateVO(entity.getProjectId(), null);
        this.budgetPlanService.recalculate(vo, 3);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetPlanEntity byId = (BudgetPlanEntity)((Object)this.budgetPlanService.getById(billId));
        if (byId.getChangeStatus() != ChangeStatusConst.UN_CHANGE) {
            return CommonResponse.error((String)"\u65bd\u5de5\u8ba1\u5212\u5904\u4e8e\u53d8\u66f4\u4e2d\u6216\u5df2\u53d8\u66f4\u72b6\u6001\u4e0d\u80fd\u5f03\u5ba1!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

