package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.budget.vo.PlanProfitVO;
import com.ejianc.business.plan.service.PlanReportService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

/**
 * @author songlx
 * @version 1.0
 * @description: 报表控制器
 * @date 2021/10/21
 */
@Controller
@RequestMapping("planReport")
public class PlanReportController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final static Integer BATCH_SIZE = 1000;

    private final static Integer QUERY_TIMEOUT = 60;

    private final static String INDEX_NAME_COST = "ejc_probudget_report_cost";

    private final static String INDEX_NAME_PROFIT = "ejc_probudget_report_profit";


    @Autowired(required = false)
    private RestHighLevelClient client;

    @Autowired
    private PlanReportService planReportService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @description: 成本控制表
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/10/21
     */
    @RequestMapping(path = "/initCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> initCost() {
        try {
            XContentBuilder mapping = jsonBuilder().startObject().startObject(INDEX_NAME_COST).startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("projectId").field("type", "text").endObject();
            mapping.startObject("projectName").field("type", "keyword").endObject();
            //.field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart")
            mapping.startObject("orgId").field("type", "text").endObject();
            mapping.startObject("orgName").field("type", "keyword").endObject();
            //.field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart")
            mapping.startObject("parentOrgId").field("type", "text").endObject();
            mapping.startObject("parentOrgName").field("type", "keyword").endObject();
            //.field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart")
            mapping.startObject("budgetId").field("type", "text").endObject();
            mapping.startObject("yyearMonth").field("type", "text").endObject();
            mapping.startObject("budgetPrice").field("type", "long").endObject();
            mapping.startObject("budgetNum").field("type", "long").endObject();
            mapping.startObject("realPrice").field("type", "long").endObject();

            mapping.startObject("realNum").field("type", "long").endObject();
            mapping.startObject("computeNum").field("type", "long").endObject();
            mapping.startObject("curNum").field("type", "long").endObject();

            mapping.startObject("planBudgetCost").field("type", "long").endObject();
            mapping.startObject("manageRate").field("type", "long").endObject();
            mapping.startObject("manageRatePlus").field("type", "long").endObject();

            mapping.startObject("realCost").field("type", "long").endObject();
            mapping.startObject("computeCost").field("type", "long").endObject();
            mapping.startObject("curCost").field("type", "long").endObject();
            mapping.startObject("subCost").field("type", "long").endObject();
            mapping.startObject("materialCost").field("type", "long").endObject();
            mapping.startObject("equipPurchaseCost").field("type", "long").endObject();
            mapping.startObject("equipRentCost").field("type", "long").endObject();
            mapping.startObject("loadReimburseCost").field("type", "long").endObject();
            mapping.startObject("payReimburseCost").field("type", "long").endObject();

            mapping.startObject("finishBudget").field("type", "long").endObject();

            mapping.startObject("planDiff").field("type", "long").endObject();

            mapping.startObject("costDiff").field("type", "long").endObject();

            mapping.startObject("workAchi").field("type", "long").endObject();

            mapping.startObject("costAchi").field("type", "long").endObject();

            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest(INDEX_NAME_COST).type(INDEX_NAME_COST).source(mapping);
            client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.error("初始化失败");
    }


    private CommonResponse<JSONObject> loadCostList2ES(QueryParam param) {
        BulkRequest bulkRequest = new BulkRequest();
        List<PlanCostVO> list = planReportService.loadCostList2ES(param);
        for (PlanCostVO vo : list) {

            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put("tenantId", String.valueOf(vo.getTenantId()));
            dataMap.put("projectId", String.valueOf(vo.getProjectId()));
            dataMap.put("projectName", vo.getProjectName());
            dataMap.put("orgId", String.valueOf(vo.getOrgId()));
            dataMap.put("orgName", vo.getOrgName());
            dataMap.put("parentOrgId", String.valueOf(vo.getParentOrgId()));
            dataMap.put("parentOrgName", vo.getParentOrgName());
            dataMap.put("budgetId", String.valueOf(vo.getBudgetId()));
            dataMap.put("yyearMonth", vo.getYyearMonth());
            dataMap.put("budgetPrice", vo.getBudgetPrice());
            dataMap.put("budgetNum", vo.getBudgetNum());
            dataMap.put("realPrice", vo.getRealPrice());
            dataMap.put("realNum", vo.getRealNum());
            dataMap.put("computeNum", vo.getComputeNum());
            dataMap.put("curNum", vo.getCurNum());
            dataMap.put("planBudgetCost", vo.getPlanBudgetCost());
            dataMap.put("manageRate", vo.getManageRate());
            dataMap.put("manageRatePlus", vo.getManageRatePlus());

            dataMap.put("realCost", vo.getRealCost());
            dataMap.put("computeCost", vo.getComputeCost());
            dataMap.put("curCost", vo.getCurCost());
            dataMap.put("subCost", vo.getSubCost());
            dataMap.put("materialCost", vo.getMaterialCost());
            dataMap.put("equipPurchaseCost", vo.getEquipPurchaseCost());
            dataMap.put("equipRentCost", vo.getEquipRentCost());
            dataMap.put("loadReimburseCost", vo.getLoadReimburseCost());
            dataMap.put("payReimburseCost", vo.getPayReimburseCost());

            dataMap.put("finishBudget", vo.getFinishBudget());
            dataMap.put("planDiff", vo.getPlanDiff());
            dataMap.put("costDiff", vo.getCostDiff());
            dataMap.put("workAchi", vo.getWorkAchi());
            dataMap.put("costAchi", vo.getCostAchi());
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME_COST);
            indexRequest.id(String.valueOf(vo.getProjectId()));
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        if (bulkRequest.requests().size() > 0) {
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                client.bulk(bulkRequest, RequestOptions.DEFAULT);
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return CommonResponse.success("成本控制重新加载成功条数: " + bulkRequest.requests().size());
    }


    @RequestMapping(value = "/reloadCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanCostVO> reloadCost(@RequestBody QueryParam param) {

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        try {
            this.deleteESData(INDEX_NAME_COST);
            this.loadCostList2ES(param);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return CommonResponse.success("重新加载成本控制数据成功！");
    }

    @RequestMapping(value = "/queryCostList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanCostVO>> queryCostList(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        IPage<PlanCostVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_COST);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));


        if (InvocationInfoProxy.getOrgId() != null) {
            boolQuery.must(QueryBuilders.termsQuery("orgId", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            UserContext userContext = sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            if (StringUtils.isNotEmpty(authOrgIds)) {
                String[] orgIds = authOrgIds.split(",");
                boolQuery.must(QueryBuilders.termsQuery("orgId", orgIds));
            }
        }

        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must(QueryBuilders.boolQuery().should(QueryBuilders.wildcardQuery("projectName","*"+param.getSearchText()+"*"))
                    .should(QueryBuilders.wildcardQuery("parentOrgName","*"+param.getSearchText()+"*"))
                    .should(QueryBuilders.wildcardQuery("orgName","*"+param.getSearchText()+"*")));
            //boolQuery.must(QueryBuilders.multiMatchQuery(param.getSearchText(), "parentOrgName", "orgName"));
        }
        Map<String, Parameter> params = param.getParams();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isEmpty(value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must(QueryBuilders.termsQuery(key, vals));
                } else {
                    boolQuery.must(QueryBuilders.wildcardQuery(key, "*"+value+"*"));
                }
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        List<PlanCostVO> list = new ArrayList<>();
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, PlanCostVO.class));
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询成本控制列表数据成功！", page);
    }


    /**
     * @Author xuannl
     * @Date 2021/10/28 导出
     * @Description excelCostExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelCostExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelCostExport(@RequestBody QueryParam param, HttpServletResponse response) {
        int pageNumber = 0;
        int pageSize = 10000;
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_COST);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must(QueryBuilders.termsQuery("orgId", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery(param.getSearchText(),"parentOrgName"));
            boolQuery.must(QueryBuilders.matchPhraseQuery(param.getSearchText(),"orgName"));
            //boolQuery.must(QueryBuilders.multiMatchQuery(param.getSearchText(), "parentOrgName", "orgName"));
        }
        Map<String, Parameter> params = param.getParams();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isEmpty(value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must(QueryBuilders.termsQuery(key, vals));
                } else {
                    boolQuery.must(QueryBuilders.matchQuery(key, value));
                }

            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        List<PlanCostVO> list = new ArrayList<>();
        SearchResponse responseTemp = null;
        try {
            responseTemp = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = responseTemp.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, PlanCostVO.class));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        String fileName = "costListExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }


    /**
     * @description: 毛利对比表
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/10/21
     */
    @RequestMapping(path = "/initProfit", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> initProfit() {
        try {
            XContentBuilder mapping = jsonBuilder().startObject().startObject(INDEX_NAME_PROFIT).startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("projectId").field("type", "text").endObject();
            mapping.startObject("projectName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("orgId").field("type", "text").endObject();
            mapping.startObject("orgName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("parentOrgId").field("type", "text").endObject();
            mapping.startObject("parentOrgName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("budgetId").field("type", "text").endObject();

            mapping.startObject("incomebudgetMny").field("type", "long").endObject();

            mapping.startObject("productionMny").field("type", "long").endObject();

            mapping.startObject("laborMny").field("type", "long").endObject();

            mapping.startObject("realCost").field("type", "long").endObject();
            mapping.startObject("computeCost").field("type", "long").endObject();
            mapping.startObject("curCost").field("type", "long").endObject();
            mapping.startObject("subCost").field("type", "long").endObject();

            mapping.startObject("materialMny").field("type", "long").endObject();
            mapping.startObject("materialCost").field("type", "long").endObject();

            mapping.startObject("manageMny").field("type", "long").endObject();
            mapping.startObject("realManageMny").field("type", "long").endObject();
            mapping.startObject("equipPurchaseCost").field("type", "long").endObject();
            mapping.startObject("equipRentCost").field("type", "long").endObject();
            mapping.startObject("loadReimburseCost").field("type", "long").endObject();
            mapping.startObject("payReimburseCost").field("type", "long").endObject();

            mapping.startObject("taxFee").field("type", "long").endObject();
            mapping.startObject("realTaxFee").field("type", "long").endObject();
            mapping.startObject("taxRatio").field("type", "long").endObject();

            mapping.startObject("planProfit").field("type", "long").endObject();
            mapping.startObject("planProfitTxt").field("type", "text").endObject();
            mapping.startObject("costbudgetMny").field("type", "long").endObject();
            mapping.startObject("realProfit").field("type", "long").endObject();

            mapping.startObject("basePlanProfit").field("type", "long").endObject();
            mapping.startObject("basePlanProfitTxt").field("type", "text").endObject();
            mapping.startObject("baseIncomebudgetMny").field("type", "long").endObject();
            mapping.startObject("baseCostbudgetMny").field("type", "long").endObject();

            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest(INDEX_NAME_PROFIT).type(INDEX_NAME_PROFIT).source(mapping);
            client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.error("初始化失败");
    }


    private CommonResponse<JSONObject> loadProfitList2ES(QueryParam param) {
        BulkRequest bulkRequest = new BulkRequest();
        List<PlanProfitVO> list = planReportService.loadProfitList2ES(param);
        for (PlanProfitVO vo : list) {
            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put("tenantId", String.valueOf(vo.getTenantId()));
            dataMap.put("projectId", String.valueOf(vo.getProjectId()));
            dataMap.put("projectName", vo.getProjectName());
            dataMap.put("orgId", String.valueOf(vo.getOrgId()));
            dataMap.put("orgName", vo.getOrgName());
            dataMap.put("parentOrgId", String.valueOf(vo.getParentOrgId()));
            dataMap.put("parentOrgName", vo.getParentOrgName());
            dataMap.put("budgetId", String.valueOf(vo.getBudgetId()));

            dataMap.put("incomebudgetMny", vo.getIncomebudgetMny());
            dataMap.put("productionMny", vo.getProductionMny());
            dataMap.put("laborMny", vo.getLaborMny());
            dataMap.put("realCost", vo.getRealCost());
            dataMap.put("computeCost", vo.getComputeCost());

            dataMap.put("curCost", vo.getCurCost());
            dataMap.put("subCost", vo.getSubCost());

            dataMap.put("materialMny", vo.getMaterialMny());
            dataMap.put("materialCost", vo.getMaterialCost());

            dataMap.put("manageMny", vo.getManageMny());
            dataMap.put("realManageMny", vo.getRealManageMny());
            dataMap.put("equipPurchaseCost", vo.getEquipPurchaseCost());
            dataMap.put("equipRentCost", vo.getEquipRentCost());
            dataMap.put("loadReimburseCost", vo.getLoadReimburseCost());
            dataMap.put("payReimburseCost", vo.getPayReimburseCost());

            dataMap.put("taxFee", vo.getTaxFee());
            dataMap.put("realTaxFee", vo.getRealTaxFee());
            dataMap.put("taxRatio", vo.getTaxRatio());

            dataMap.put("planProfit", vo.getPlanProfit());
            dataMap.put("planProfitTxt", vo.getPlanProfitTxt());
            dataMap.put("costbudgetMny", vo.getCostbudgetMny());

            dataMap.put("realProfit", vo.getRealProfit());

            dataMap.put("basePlanProfit", vo.getBasePlanProfit());
            dataMap.put("basePlanProfitTxt", vo.getBasePlanProfitTxt());
            dataMap.put("baseIncomebudgetMny", vo.getBaseIncomebudgetMny());

            dataMap.put("baseCostbudgetMny", vo.getBaseCostbudgetMny());
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME_PROFIT);
            indexRequest.id(String.valueOf(vo.getProjectId()));
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        if (bulkRequest.requests().size() > 0) {
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                client.bulk(bulkRequest, RequestOptions.DEFAULT);
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return CommonResponse.success("毛利对比重新加载成功条数: " + bulkRequest.requests().size());
    }


    @RequestMapping(value = "/reloadProfit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanProfitVO> reloadProfit(@RequestBody QueryParam param) {

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        try {
            this.deleteESData(INDEX_NAME_PROFIT);
            this.loadProfitList2ES(param);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return CommonResponse.success("重新加载毛利对比数据成功！");
    }


    @RequestMapping(value = "/queryProfitList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanProfitVO>> queryProfitList(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        IPage<PlanProfitVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_PROFIT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must(QueryBuilders.termsQuery("orgId", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must(QueryBuilders.multiMatchQuery(param.getSearchText(), "parentOrgName", "projectName"));
        }
        Map<String, Parameter> params = param.getParams();

        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isEmpty(value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must(QueryBuilders.termsQuery(key, vals));
                } else {
                    boolQuery.must(QueryBuilders.matchQuery(key, value));
                }
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        List<PlanProfitVO> list = new ArrayList<>();
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, PlanProfitVO.class));
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询毛利对比列表数据成功！", page);
    }

    /**
     * @Author xuannl
     * @Date 2021/10/28 导出
     * @Description excelProfitExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelProfitExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelProfitExport(@RequestBody QueryParam param, HttpServletResponse response) {
        int pageNumber = 0;
        int pageSize = 10000;
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_PROFIT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must(QueryBuilders.termsQuery("orgId", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must(QueryBuilders.multiMatchQuery(param.getSearchText(), "parentOrgName", "projectName"));
        }
        Map<String, Parameter> params = param.getParams();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isEmpty(value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must(QueryBuilders.termsQuery(key, vals));
                } else {
                    boolQuery.must(QueryBuilders.matchQuery(key, value));
                }
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        List<PlanProfitVO> list = new ArrayList<>();
        SearchResponse responseTemp = null;
        try {
            responseTemp = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = responseTemp.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, PlanProfitVO.class));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        String fileName = "profitListExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    private long deleteESData(String indexName) throws IOException {
        Long resultSize = queryIndexSize(indexName);
        Long deleteTimes = resultSize % BATCH_SIZE;
        for (int i = 0; i < deleteTimes + 1; i++) {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(indexName);
            deleteByQueryRequest.setQuery(new TermQueryBuilder("tenantId", InvocationInfoProxy.getTenantid()));
            deleteByQueryRequest.setBatchSize(BATCH_SIZE);
            BulkByScrollResponse response = client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        return 0;
    }

    private Long queryIndexSize(String indexName) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(indexName);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        // 查询参数
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid());

        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must(termQueryBuilder);

        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); // 设置超时时间

        searchRequest.source(sourceBuilder);

        try {
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        } catch (IOException e) {
            try { //  重试一次
                SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            } catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}
